/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.expression.condition;

import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionVisitor;
import com.craftaro.third_party.org.h2.expression.TypedValueExpression;
import com.craftaro.third_party.org.h2.expression.ValueExpression;
import com.craftaro.third_party.org.h2.expression.condition.Condition;
import com.craftaro.third_party.org.h2.table.ColumnResolver;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueNull;

public class ConditionNot
extends Condition {
    private Expression condition;

    public ConditionNot(Expression expression) {
        this.condition = expression;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return ConditionNot.castToBoolean(session, this.condition);
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.condition.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return value;
        }
        return value.convertTo(1).negate();
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.condition.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        Expression expression = this.condition.getNotIfPossible(session);
        if (expression != null) {
            return expression.optimize(session);
        }
        Expression expression2 = this.condition.optimize(session);
        if (expression2.isConstant()) {
            Value value = expression2.getValue(session);
            if (value == ValueNull.INSTANCE) {
                return TypedValueExpression.getUnknown();
            }
            return ValueExpression.getBoolean(!value.getBoolean());
        }
        this.condition = expression2;
        return this;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.condition.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append("(NOT ");
        return this.condition.getSQL(stringBuilder, bl).append(')');
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.condition.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        return this.condition.isEverything(expressionVisitor);
    }

    @Override
    public int getCost() {
        return this.condition.getCost();
    }

    @Override
    public int getSubexpressionCount() {
        return 1;
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.condition;
        }
        throw new IndexOutOfBoundsException();
    }
}

