/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.expression.condition;

import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionColumn;
import com.craftaro.third_party.org.h2.expression.ExpressionVisitor;
import com.craftaro.third_party.org.h2.expression.condition.Comparison;
import com.craftaro.third_party.org.h2.expression.condition.Condition;
import com.craftaro.third_party.org.h2.index.IndexCondition;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.table.ColumnResolver;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueBoolean;
import com.craftaro.third_party.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.TreeSet;

public class ConditionInConstantSet
extends Condition {
    private Expression left;
    private final ArrayList<Expression> valueList;
    private final TreeSet<Value> valueSet;
    private boolean hasNull;
    private final TypeInfo type;

    public ConditionInConstantSet(Session session, Expression expression, ArrayList<Expression> arrayList) {
        this.left = expression;
        this.valueList = arrayList;
        Database database = session.getDatabase();
        this.valueSet = new TreeSet<Value>(database.getCompareMode());
        this.type = expression.getType();
        for (Expression expression2 : arrayList) {
            this.add(expression2.getValue(session).convertTo(this.type, database, true, null));
        }
    }

    private void add(Value value) {
        if (value.containsNull()) {
            this.hasNull = true;
        } else {
            this.valueSet.add(value);
        }
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        if (value.containsNull()) {
            return value;
        }
        boolean bl = this.valueSet.contains(value);
        if (!bl && this.hasNull) {
            return ValueNull.INSTANCE;
        }
        return ValueBoolean.get(bl);
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
        this.left.mapColumns(columnResolver, n, n2);
    }

    @Override
    public Expression optimize(Session session) {
        this.left = this.left.optimize(session);
        return this;
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        if (!(this.left instanceof ExpressionColumn)) {
            return;
        }
        ExpressionColumn expressionColumn = (ExpressionColumn)this.left;
        if (tableFilter != expressionColumn.getTableFilter()) {
            return;
        }
        if (session.getDatabase().getSettings().optimizeInList) {
            tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, this.valueList));
        }
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
        this.left.setEvaluatable(tableFilter, bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append('(');
        this.left.getSQL(stringBuilder, bl).append(" IN(");
        ConditionInConstantSet.writeExpressions(stringBuilder, this.valueList, bl);
        return stringBuilder.append("))");
    }

    @Override
    public void updateAggregate(Session session, int n) {
        this.left.updateAggregate(session, n);
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        if (!this.left.isEverything(expressionVisitor)) {
            return false;
        }
        switch (expressionVisitor.getType()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return this.left.getCost();
    }

    Expression getAdditional(Session session, Comparison comparison) {
        Expression expression = comparison.getIfEquals(this.left);
        if (expression != null && expression.isConstant()) {
            this.valueList.add(expression);
            this.add(expression.getValue(session).convertTo(this.type, session.getDatabase(), true, null));
            return this;
        }
        return null;
    }

    @Override
    public int getSubexpressionCount() {
        return 1 + this.valueList.size();
    }

    @Override
    public Expression getSubexpression(int n) {
        if (n == 0) {
            return this.left;
        }
        if (n > 0 && n <= this.valueList.size()) {
            return this.valueList.get(n - 1);
        }
        throw new IndexOutOfBoundsException();
    }
}

