/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.expression.condition;

import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionColumn;
import com.craftaro.third_party.org.h2.expression.TypedValueExpression;
import com.craftaro.third_party.org.h2.expression.ValueExpression;
import com.craftaro.third_party.org.h2.expression.condition.SimplePredicate;
import com.craftaro.third_party.org.h2.index.IndexCondition;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueBoolean;
import com.craftaro.third_party.org.h2.value.ValueNull;
import java.util.ArrayList;

public class BooleanTest
extends SimplePredicate {
    private final Boolean right;

    public BooleanTest(Expression expression, boolean bl, Boolean bl2) {
        super(expression, bl);
        this.right = bl2;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return this.left.getSQL(stringBuilder.append('('), bl).append(this.not ? " IS NOT " : " IS ").append(this.right == null ? "UNKNOWN)" : (this.right != false ? "TRUE)" : "FALSE)"));
    }

    @Override
    public Value getValue(Session session) {
        Value value = this.left.getValue(session);
        return ValueBoolean.get((value == ValueNull.INSTANCE ? this.right == null : this.right != null && this.right.booleanValue() == value.getBoolean()) ^ this.not);
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new BooleanTest(this.left, !this.not, this.right);
    }

    @Override
    public void createIndexConditions(Session session, TableFilter tableFilter) {
        ExpressionColumn expressionColumn;
        if (!tableFilter.getTable().isQueryComparable()) {
            return;
        }
        if (this.left instanceof ExpressionColumn && (expressionColumn = (ExpressionColumn)this.left).getType().getValueType() == 1 && tableFilter == expressionColumn.getTableFilter()) {
            if (this.not) {
                if (this.right == null && expressionColumn.getColumn().isNullable()) {
                    ArrayList<Expression> arrayList = new ArrayList<Expression>(2);
                    arrayList.add(ValueExpression.getBoolean(false));
                    arrayList.add(ValueExpression.getBoolean(true));
                    tableFilter.addIndexCondition(IndexCondition.getInList(expressionColumn, arrayList));
                }
            } else {
                tableFilter.addIndexCondition(IndexCondition.get(16, expressionColumn, this.right == null ? TypedValueExpression.getUnknown() : ValueExpression.getBoolean(this.right)));
            }
        }
    }
}

