/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.expression;

import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionVisitor;
import com.craftaro.third_party.org.h2.expression.ParameterInterface;
import com.craftaro.third_party.org.h2.expression.ValueExpression;
import com.craftaro.third_party.org.h2.expression.condition.Comparison;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.ColumnResolver;
import com.craftaro.third_party.org.h2.table.TableFilter;
import com.craftaro.third_party.org.h2.value.TypeInfo;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueBoolean;
import com.craftaro.third_party.org.h2.value.ValueNull;
import com.craftaro.third_party.org.h2.value.ValueString;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private final int index;

    public Parameter(int n) {
        this.index = n;
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append('?').append(this.index + 1);
    }

    @Override
    public void setValue(Value value, boolean bl) {
        this.value = value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    @Override
    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    @Override
    public Value getValue(Session session) {
        return this.getParamValue();
    }

    @Override
    public TypeInfo getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return TypeInfo.TYPE_UNKNOWN;
    }

    @Override
    public void mapColumns(ColumnResolver columnResolver, int n, int n2) {
    }

    @Override
    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    @Override
    public Expression optimize(Session session) {
        if (session.getDatabase().getMode().treatEmptyStringsAsNull && this.value instanceof ValueString && this.value.getString().isEmpty()) {
            this.value = ValueNull.INSTANCE;
        }
        return this;
    }

    @Override
    public boolean isConstant() {
        return false;
    }

    @Override
    public boolean isValueSet() {
        return this.value != null;
    }

    @Override
    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    @Override
    public void updateAggregate(Session session, int n) {
    }

    @Override
    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.FALSE));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

