/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.command.ddl;

import com.craftaro.third_party.org.h2.command.ddl.DefineCommand;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.engine.UserAggregate;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.schema.Schema;

public class CreateAggregate
extends DefineCommand {
    private Schema schema;
    private String name;
    private String javaClassMethod;
    private boolean ifNotExists;
    private boolean force;

    public CreateAggregate(Session session) {
        super(session);
    }

    @Override
    public int update() {
        this.session.commit(true);
        this.session.getUser().checkAdmin();
        Database database = this.session.getDatabase();
        if (database.findAggregate(this.name) != null || this.schema.findFunction(this.name) != null) {
            if (!this.ifNotExists) {
                throw DbException.get(90076, this.name);
            }
        } else {
            int n = this.getObjectId();
            UserAggregate userAggregate = new UserAggregate(database, n, this.name, this.javaClassMethod, this.force);
            database.addDatabaseObject(this.session, userAggregate);
        }
        return 0;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setJavaClassMethod(String string) {
        this.javaClassMethod = string;
    }

    public void setIfNotExists(boolean bl) {
        this.ifNotExists = bl;
    }

    public void setForce(boolean bl) {
        this.force = bl;
    }

    @Override
    public int getType() {
        return 22;
    }
}

