/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.command;

import com.craftaro.third_party.org.h2.command.Command;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.DbObject;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.Parameter;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.message.Trace;
import com.craftaro.third_party.org.h2.result.ResultInterface;
import com.craftaro.third_party.org.h2.table.TableView;
import com.craftaro.third_party.org.h2.util.MathUtils;
import com.craftaro.third_party.org.h2.value.Value;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public abstract class Prepared {
    protected Session session;
    protected String sqlStatement;
    protected boolean create = true;
    protected ArrayList<Parameter> parameters;
    protected boolean prepareAlways;
    private long modificationMetaId;
    private Command command;
    private int persistedObjectId;
    private long currentRowNumber;
    private int rowScanCount;
    private List<TableView> cteCleanups;

    public Prepared(Session session) {
        this.session = session;
        this.modificationMetaId = session.getDatabase().getModificationMetaId();
    }

    public abstract boolean isTransactional();

    public abstract ResultInterface queryMeta();

    public abstract int getType();

    public boolean isReadOnly() {
        return false;
    }

    public boolean needRecompile() {
        Database database = this.session.getDatabase();
        if (database == null) {
            throw DbException.get(90067, "database closed");
        }
        return this.prepareAlways || this.modificationMetaId < database.getModificationMetaId() || database.getSettings().recompileAlways;
    }

    long getModificationMetaId() {
        return this.modificationMetaId;
    }

    void setModificationMetaId(long l) {
        this.modificationMetaId = l;
    }

    public void setParameterList(ArrayList<Parameter> arrayList) {
        this.parameters = arrayList;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    protected void checkParameters() {
        if (this.persistedObjectId < 0) {
            this.persistedObjectId = -this.persistedObjectId - 1;
        }
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                parameter.checkSet();
            }
        }
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public boolean isQuery() {
        return false;
    }

    public void prepare() {
    }

    public int update() {
        throw DbException.get(90001);
    }

    public ResultInterface query(int n) {
        throw DbException.get(90002);
    }

    public void setSQL(String string) {
        this.sqlStatement = string;
    }

    public String getSQL() {
        return this.sqlStatement;
    }

    protected int getPersistedObjectId() {
        int n = this.persistedObjectId;
        return n >= 0 ? n : 0;
    }

    protected int getObjectId() {
        int n = this.persistedObjectId;
        if (n == 0) {
            n = this.session.getDatabase().allocateObjectId();
        } else if (n < 0) {
            throw DbException.throwInternalError("Prepared.getObjectId() was called before");
        }
        this.persistedObjectId = -this.persistedObjectId - 1;
        return n;
    }

    public String getPlanSQL(boolean bl) {
        return null;
    }

    public void checkCanceled() {
        Command command;
        this.session.checkCanceled();
        Command command2 = command = this.command != null ? this.command : this.session.getCurrentCommand();
        if (command != null) {
            command.checkCanceled();
        }
    }

    public void setPersistedObjectId(int n) {
        this.persistedObjectId = n;
        this.create = false;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    void trace(long l, int n) {
        long l2;
        if (this.session.getTrace().isInfoEnabled() && l > 0L) {
            l2 = System.nanoTime() - l;
            String string = Trace.formatParams(this.parameters);
            this.session.getTrace().infoSQL(this.sqlStatement, string, n, l2 / 1000L / 1000L);
        }
        if (this.session.getDatabase().getQueryStatistics() && l != 0L) {
            l2 = System.nanoTime() - l;
            this.session.getDatabase().getQueryStatisticsData().update(this.toString(), l2, n);
        }
    }

    public void setPrepareAlways(boolean bl) {
        this.prepareAlways = bl;
    }

    public void setCurrentRowNumber(long l) {
        if ((++this.rowScanCount & 0x7F) == 0) {
            this.checkCanceled();
        }
        this.currentRowNumber = l;
        this.setProgress();
    }

    public long getCurrentRowNumber() {
        return this.currentRowNumber;
    }

    private void setProgress() {
        if ((this.currentRowNumber & 0x7FL) == 0L) {
            this.session.getDatabase().setProgress(7, this.sqlStatement, MathUtils.convertLongToInt(this.currentRowNumber), 0);
        }
    }

    public String toString() {
        return this.sqlStatement;
    }

    protected static String getSQL(Value[] valueArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = valueArray.length;
        for (int i = 0; i < n; ++i) {
            Value value;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if ((value = valueArray[i]) == null) continue;
            value.getSQL(stringBuilder);
        }
        return stringBuilder.toString();
    }

    protected static String getSimpleSQL(Expression[] expressionArray) {
        StringBuilder stringBuilder = new StringBuilder();
        Expression.writeExpressions(stringBuilder, expressionArray, false);
        return stringBuilder.toString();
    }

    protected DbException setRow(DbException dbException, int n, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.sqlStatement != null) {
            stringBuilder.append(this.sqlStatement);
        }
        stringBuilder.append(" -- ");
        if (n > 0) {
            stringBuilder.append("row #").append(n + 1).append(' ');
        }
        stringBuilder.append('(').append(string).append(')');
        return dbException.addSQL(stringBuilder.toString());
    }

    public boolean isCacheable() {
        return false;
    }

    public List<TableView> getCteCleanups() {
        return this.cteCleanups;
    }

    public void setCteCleanups(List<TableView> list) {
        this.cteCleanups = list;
    }

    public Session getSession() {
        return this.session;
    }

    public void collectDependencies(HashSet<DbObject> hashSet) {
    }
}

