/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.h2.command;

import com.craftaro.third_party.org.h2.command.Command;
import com.craftaro.third_party.org.h2.command.Parser;
import com.craftaro.third_party.org.h2.command.Prepared;
import com.craftaro.third_party.org.h2.command.dml.DataChangeStatement;
import com.craftaro.third_party.org.h2.command.dml.Explain;
import com.craftaro.third_party.org.h2.command.dml.Query;
import com.craftaro.third_party.org.h2.engine.Database;
import com.craftaro.third_party.org.h2.engine.DbObject;
import com.craftaro.third_party.org.h2.engine.DbSettings;
import com.craftaro.third_party.org.h2.engine.Session;
import com.craftaro.third_party.org.h2.expression.Expression;
import com.craftaro.third_party.org.h2.expression.ExpressionColumn;
import com.craftaro.third_party.org.h2.expression.Parameter;
import com.craftaro.third_party.org.h2.expression.ParameterInterface;
import com.craftaro.third_party.org.h2.message.DbException;
import com.craftaro.third_party.org.h2.result.LocalResult;
import com.craftaro.third_party.org.h2.result.ResultInterface;
import com.craftaro.third_party.org.h2.result.ResultTarget;
import com.craftaro.third_party.org.h2.result.ResultWithGeneratedKeys;
import com.craftaro.third_party.org.h2.table.Column;
import com.craftaro.third_party.org.h2.table.DataChangeDeltaTable;
import com.craftaro.third_party.org.h2.table.Table;
import com.craftaro.third_party.org.h2.table.TableView;
import com.craftaro.third_party.org.h2.util.StringUtils;
import com.craftaro.third_party.org.h2.util.Utils;
import com.craftaro.third_party.org.h2.value.Value;
import com.craftaro.third_party.org.h2.value.ValueNull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CommandContainer
extends Command {
    private Prepared prepared;
    private boolean readOnlyKnown;
    private boolean readOnly;

    static void clearCTE(Session session, Prepared prepared) {
        List<TableView> list = prepared.getCteCleanups();
        if (list != null) {
            CommandContainer.clearCTE(session, list);
        }
    }

    static void clearCTE(Session session, List<TableView> list) {
        for (TableView tableView : list) {
            if (tableView.getName() == null) continue;
            session.removeLocalTempTable(tableView);
        }
    }

    CommandContainer(Session session, String string, Prepared prepared) {
        super(session, string);
        prepared.setCommand(this);
        this.prepared = prepared;
    }

    @Override
    public ArrayList<? extends ParameterInterface> getParameters() {
        return this.prepared.getParameters();
    }

    @Override
    public boolean isTransactional() {
        return this.prepared.isTransactional();
    }

    @Override
    public boolean isQuery() {
        return this.prepared.isQuery();
    }

    @Override
    public void prepareJoinBatch() {
        if (this.session.isJoinBatchEnabled()) {
            CommandContainer.prepareJoinBatch(this.prepared);
        }
    }

    private static void prepareJoinBatch(Prepared prepared) {
        if (prepared.isQuery()) {
            int n = prepared.getType();
            if (n == 66) {
                ((Query)prepared).prepareJoinBatch();
            } else if (n == 60 || n == 86) {
                CommandContainer.prepareJoinBatch(((Explain)prepared).getCommand());
            }
        }
    }

    private void recompileIfRequired() {
        if (this.prepared.needRecompile()) {
            this.prepared.setModificationMetaId(0L);
            String string = this.prepared.getSQL();
            ArrayList<Parameter> arrayList = this.prepared.getParameters();
            Parser parser = new Parser(this.session);
            this.prepared = parser.parse(string);
            long l = this.prepared.getModificationMetaId();
            this.prepared.setModificationMetaId(0L);
            ArrayList<Parameter> arrayList2 = this.prepared.getParameters();
            int n = arrayList2.size();
            for (int i = 0; i < n; ++i) {
                Parameter parameter = arrayList.get(i);
                if (!parameter.isValueSet()) continue;
                Value value = parameter.getValue(this.session);
                Parameter parameter2 = arrayList2.get(i);
                parameter2.setValue(value);
            }
            this.prepared.prepare();
            this.prepared.setModificationMetaId(l);
            this.prepareJoinBatch();
        }
    }

    @Override
    public ResultWithGeneratedKeys update(Object object) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.session.setLastScopeIdentity(ValueNull.INSTANCE);
        this.prepared.checkParameters();
        ResultWithGeneratedKeys resultWithGeneratedKeys = object != null && !Boolean.FALSE.equals(object) ? (this.prepared instanceof DataChangeStatement && this.prepared.getType() != 58 ? this.executeUpdateWithGeneratedKeys((DataChangeStatement)((Object)this.prepared), object) : new ResultWithGeneratedKeys.WithKeys(this.prepared.update(), this.session.getDatabase().getResultFactory().create())) : ResultWithGeneratedKeys.of(this.prepared.update());
        this.prepared.trace(this.startTimeNanos, resultWithGeneratedKeys.getUpdateCount());
        this.setProgress(6);
        return resultWithGeneratedKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private ResultWithGeneratedKeys executeUpdateWithGeneratedKeys(DataChangeStatement dataChangeStatement, Object object) {
        int n;
        void var9_18;
        int n2;
        Object[] objectArray;
        Object[] objectArray2;
        ArrayList<Object> arrayList;
        Database database = this.session.getDatabase();
        Table table = dataChangeStatement.getTable();
        if (Boolean.TRUE.equals(object)) {
            arrayList = Utils.newSmallArrayList();
            objectArray2 = table.getColumns();
            objectArray = table.findPrimaryKey();
            for (Column column : objectArray2) {
                Expression expression = column.getDefaultExpression();
                if ((expression == null || expression.isConstant()) && (objectArray == null || objectArray.getColumnIndex(column) < 0)) continue;
                arrayList.add(new ExpressionColumn(database, column));
            }
        } else if (object instanceof int[]) {
            objectArray2 = (int[])object;
            objectArray = table.getColumns();
            int n3 = objectArray.length;
            arrayList = new ArrayList(objectArray2.length);
            for (Column column : objectArray2) {
                if (column < true || column > n3) {
                    throw DbException.get(42122, "Index: " + (int)column);
                }
                arrayList.add(new ExpressionColumn(database, (Column)objectArray[column - true]));
            }
        } else if (object instanceof String[]) {
            void var9_16;
            objectArray2 = (String[])object;
            arrayList = new ArrayList(objectArray2.length);
            objectArray = objectArray2;
            int n3 = objectArray.length;
            boolean localResult = false;
            while (var9_16 < n3) {
                Column column;
                block21: {
                    Column column2 = objectArray[var9_16];
                    column = table.findColumn((String)((Object)column2));
                    if (column == null) {
                        DbSettings dbSettings = database.getSettings();
                        if (dbSettings.databaseToUpper) {
                            column = table.findColumn(StringUtils.toUpperEnglish((String)((Object)column2)));
                        } else if (dbSettings.databaseToLower) {
                            column = table.findColumn(StringUtils.toLowerEnglish((String)((Object)column2)));
                        }
                        if (column == null) {
                            for (Column column3 : table.getColumns()) {
                                if (!column3.getName().equalsIgnoreCase((String)((Object)column2))) continue;
                                column = column3;
                                break block21;
                            }
                            throw DbException.get(42122, (String)((Object)column2));
                        }
                    }
                }
                arrayList.add(new ExpressionColumn(database, column));
                ++var9_16;
            }
        } else {
            throw DbException.throwInternalError();
        }
        if ((n2 = arrayList.size()) == 0) {
            return new ResultWithGeneratedKeys.WithKeys(dataChangeStatement.update(), database.getResultFactory().create());
        }
        objectArray = new int[n2];
        Expression[] expressionArray = arrayList.toArray(new ExpressionColumn[0]);
        boolean bl = false;
        while (var9_18 < n2) {
            objectArray[var9_18] = expressionArray[var9_18].getColumn().getColumnId();
            ++var9_18;
        }
        LocalResult localResult = database.getResultFactory().create(this.session, expressionArray, n2, n2);
        GeneratedKeysCollector generatedKeysCollector = new GeneratedKeysCollector((int[])objectArray, localResult);
        try {
            dataChangeStatement.setDeltaChangeCollector(generatedKeysCollector, DataChangeDeltaTable.ResultOption.FINAL);
            n = dataChangeStatement.update();
        }
        finally {
            dataChangeStatement.setDeltaChangeCollector(null, null);
        }
        return new ResultWithGeneratedKeys.WithKeys(n, localResult);
    }

    @Override
    public ResultInterface query(int n) {
        this.recompileIfRequired();
        this.setProgress(5);
        this.start();
        this.prepared.checkParameters();
        ResultInterface resultInterface = this.prepared.query(n);
        this.prepared.trace(this.startTimeNanos, resultInterface.isLazy() ? 0 : resultInterface.getRowCount());
        this.setProgress(6);
        return resultInterface;
    }

    @Override
    public void stop() {
        super.stop();
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public boolean canReuse() {
        return super.canReuse() && this.prepared.getCteCleanups() == null;
    }

    @Override
    public boolean isReadOnly() {
        if (!this.readOnlyKnown) {
            this.readOnly = this.prepared.isReadOnly();
            this.readOnlyKnown = true;
        }
        return this.readOnly;
    }

    @Override
    public ResultInterface queryMeta() {
        return this.prepared.queryMeta();
    }

    @Override
    public boolean isCacheable() {
        return this.prepared.isCacheable();
    }

    @Override
    public int getCommandType() {
        return this.prepared.getType();
    }

    void clearCTE() {
        CommandContainer.clearCTE(this.session, this.prepared);
    }

    @Override
    public Set<DbObject> getDependencies() {
        HashSet<DbObject> hashSet = new HashSet<DbObject>();
        this.prepared.collectDependencies(hashSet);
        return hashSet;
    }

    private static final class GeneratedKeysCollector
    implements ResultTarget {
        private final int[] indexes;
        private final LocalResult result;

        GeneratedKeysCollector(int[] nArray, LocalResult localResult) {
            this.indexes = nArray;
            this.result = localResult;
        }

        @Override
        public void limitsWereApplied() {
        }

        @Override
        public int getRowCount() {
            return 0;
        }

        @Override
        public void addRow(Value ... valueArray) {
            int n = this.indexes.length;
            Value[] valueArray2 = new Value[n];
            for (int i = 0; i < n; ++i) {
                valueArray2[i] = valueArray[this.indexes[i]];
            }
            this.result.addRow(valueArray2);
        }
    }
}

