/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.org.apache.commons.lang3.math;

import com.craftaro.third_party.org.apache.commons.lang3.Validate;
import java.util.Objects;

public class IEEE754rUtils {
    public static double max(double ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        double max = array[0];
        for (int j = 1; j < array.length; ++j) {
            max = IEEE754rUtils.max(array[j], max);
        }
        return max;
    }

    public static double max(double a2, double b2) {
        if (Double.isNaN(a2)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a2;
        }
        return Math.max(a2, b2);
    }

    public static double max(double a2, double b2, double c2) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a2, b2), c2);
    }

    public static float max(float ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        float max = array[0];
        for (int j = 1; j < array.length; ++j) {
            max = IEEE754rUtils.max(array[j], max);
        }
        return max;
    }

    public static float max(float a2, float b2) {
        if (Float.isNaN(a2)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a2;
        }
        return Math.max(a2, b2);
    }

    public static float max(float a2, float b2, float c2) {
        return IEEE754rUtils.max(IEEE754rUtils.max(a2, b2), c2);
    }

    public static double min(double ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        double min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = IEEE754rUtils.min(array[i], min);
        }
        return min;
    }

    public static double min(double a2, double b2) {
        if (Double.isNaN(a2)) {
            return b2;
        }
        if (Double.isNaN(b2)) {
            return a2;
        }
        return Math.min(a2, b2);
    }

    public static double min(double a2, double b2, double c2) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a2, b2), c2);
    }

    public static float min(float ... array) {
        Objects.requireNonNull(array, "array");
        Validate.isTrue(array.length != 0, "Array cannot be empty.", new Object[0]);
        float min = array[0];
        for (int i = 1; i < array.length; ++i) {
            min = IEEE754rUtils.min(array[i], min);
        }
        return min;
    }

    public static float min(float a2, float b2) {
        if (Float.isNaN(a2)) {
            return b2;
        }
        if (Float.isNaN(b2)) {
            return a2;
        }
        return Math.min(a2, b2);
    }

    public static float min(float a2, float b2, float c2) {
        return IEEE754rUtils.min(IEEE754rUtils.min(a2, b2), c2);
    }
}

