/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm;

import com.craftaro.third_party.com.cryptomorin.xseries.reflection.XReflection;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm.FlaggedNamedMemberHandle;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.jvm.classes.ClassHandle;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.minecraft.MinecraftMapping;
import com.craftaro.third_party.com.cryptomorin.xseries.reflection.parser.ReflectionParser;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Pattern;

public class MethodMemberHandle
extends FlaggedNamedMemberHandle {
    protected ClassHandle[] parameterTypes = new ClassHandle[0];

    public MethodMemberHandle(ClassHandle clazz) {
        super(clazz);
    }

    public MethodMemberHandle parameters(ClassHandle ... parameterTypes) {
        this.parameterTypes = parameterTypes;
        return this;
    }

    @Override
    public MethodMemberHandle returns(Class<?> clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle returns(ClassHandle clazz) {
        super.returns(clazz);
        return this;
    }

    @Override
    public MethodMemberHandle asStatic() {
        super.asStatic();
        return this;
    }

    public MethodMemberHandle parameters(Class<?> ... parameterTypes) {
        this.parameterTypes = (ClassHandle[])Arrays.stream(parameterTypes).map(XReflection::of).toArray(ClassHandle[]::new);
        return this;
    }

    @Override
    public MethodHandle reflect() throws ReflectiveOperationException {
        return this.clazz.getNamespace().getLookup().unreflect(this.reflectJvm());
    }

    @Override
    public MethodMemberHandle signature(String declaration) {
        return new ReflectionParser(declaration).imports(this.clazz.getNamespace()).parseMethod(this);
    }

    @Override
    public MethodMemberHandle map(MinecraftMapping mapping, @Pattern(value="\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*") String name) {
        super.map(mapping, name);
        return this;
    }

    @Override
    public MethodMemberHandle named(String ... names) {
        super.named(names);
        return this;
    }

    public Method reflectJvm() throws ReflectiveOperationException {
        Objects.requireNonNull(this.returnType, "Return type not specified");
        if (this.names.isEmpty()) {
            throw new IllegalStateException("No names specified");
        }
        Throwable errors = null;
        Method method = null;
        Class clazz = (Class)this.clazz.reflect();
        Class<?>[] parameterTypes = FlaggedNamedMemberHandle.getParameters(this, this.parameterTypes);
        Class<?> returnType = this.getReturnType();
        for (String name : this.names) {
            if (method != null) break;
            try {
                method = clazz.getDeclaredMethod(name, parameterTypes);
                if (method.getReturnType() == returnType) continue;
                throw new NoSuchMethodException("Method named '" + name + "' was found but the return types don't match: " + this.returnType + " != " + method);
            }
            catch (NoSuchMethodException ex) {
                method = null;
                if (errors == null) {
                    errors = new NoSuchMethodException("None of the methods were found for " + this);
                }
                errors.addSuppressed(ex);
            }
        }
        if (method == null) {
            throw (NoSuchMethodException)XReflection.relativizeSuppressedExceptions(errors);
        }
        return this.handleAccessible(method);
    }

    @Override
    public MethodMemberHandle clone() {
        MethodMemberHandle handle = new MethodMemberHandle(this.clazz);
        handle.returnType = this.returnType;
        handle.parameterTypes = this.parameterTypes;
        handle.isFinal = this.isFinal;
        handle.makeAccessible = this.makeAccessible;
        handle.names.addAll(this.names);
        return handle;
    }

    public String toString() {
        String str = this.getClass().getSimpleName() + '{';
        if (this.makeAccessible) {
            str = str + "protected/private ";
        }
        if (this.isFinal) {
            str = str + "final ";
        }
        if (this.returnType != null) {
            str = str + this.returnType + " ";
        }
        str = str + String.join((CharSequence)"/", this.names);
        str = str + '(' + Arrays.stream(this.parameterTypes).map(Object::toString).collect(Collectors.joining(", ")) + ')';
        return str + '}';
    }
}

