/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.world;

import com.craftaro.core.compatibility.ServerVersion;
import com.craftaro.core.nms.Nms;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;

public class SWorld {
    protected final com.craftaro.core.nms.world.SWorld sWorld;
    protected final World world;

    public SWorld(World world) {
        this.world = world;
        this.sWorld = Nms.getImplementations().getWorld().getWorld(world);
    }

    public Entity[] getEntitiesFromChunk(int x, int z) {
        Location location = new Location(null, 0.0, 0.0, 0.0);
        return (Entity[])this.getLivingEntities().stream().filter(entity -> {
            entity.getLocation(location);
            return location.getBlockX() >> 4 == x && location.getBlockZ() >> 4 == z;
        }).toArray(Entity[]::new);
    }

    public List<LivingEntity> getLivingEntities() {
        if (ServerVersion.isServerVersionBelow(ServerVersion.V1_17)) {
            return this.world.getLivingEntities();
        }
        return this.sWorld.getLivingEntities();
    }

    public World getWorld() {
        return this.world;
    }
}

