/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.world;

import com.craftaro.core.hooks.EntityStackerManager;
import com.craftaro.core.nms.Nms;
import com.craftaro.core.nms.world.SpawnedEntity;
import com.craftaro.core.utils.EntityUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Location;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;

public class SSpawner {
    protected final com.craftaro.core.nms.world.SSpawner sSpawner;
    protected final Location location;

    public SSpawner(Location location) {
        this.location = location;
        this.sSpawner = Nms.getImplementations().getWorld().getSpawner(location);
    }

    public SSpawner(CreatureSpawner spawner) {
        this(spawner.getLocation());
    }

    public int spawn(int amountToSpawn, EntityType ... types) {
        return this.spawn(amountToSpawn, "EXPLOSION_NORMAL", null, null, types);
    }

    public int spawn(int amountToSpawn, String particle, Set<XMaterial> canSpawnOn, SpawnedEntity spawned, EntityType ... types) {
        boolean useStackPlugin;
        if (this.location.getWorld() == null) {
            return 0;
        }
        if (canSpawnOn == null) {
            canSpawnOn = new HashSet<XMaterial>();
        }
        if (canSpawnOn.isEmpty()) {
            canSpawnOn.addAll(EntityUtils.getSpawnBlocks(types[0]));
        }
        int spawnCountUsed = (useStackPlugin = EntityStackerManager.isEnabled()) ? 1 : amountToSpawn;
        int amountSpawned = 0;
        while (spawnCountUsed-- > 0) {
            EntityType type = types[ThreadLocalRandom.current().nextInt(types.length)];
            LivingEntity entity = this.sSpawner.spawnEntity(type, particle, spawned, canSpawnOn);
            if (entity == null) continue;
            if (useStackPlugin && amountToSpawn >= EntityStackerManager.getMinStackSize(type)) {
                EntityStackerManager.add(entity, amountToSpawn);
                amountSpawned = amountToSpawn;
                break;
            }
            ++amountSpawned;
        }
        return amountSpawned;
    }

    public Location getLocation() {
        return this.location;
    }
}

