/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import java.util.concurrent.TimeUnit;

public class TimeUtils {
    public static String makeReadable(Long time) {
        if (time == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        long days = TimeUnit.MILLISECONDS.toDays(time);
        long hours = TimeUnit.MILLISECONDS.toHours(time) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(time));
        long minutes = TimeUnit.MILLISECONDS.toMinutes(time) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(time));
        long seconds = TimeUnit.MILLISECONDS.toSeconds(time) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(time));
        if (days != 0L) {
            sb.append(" ").append(days).append("d");
        }
        if (hours != 0L) {
            sb.append(" ").append(hours).append("h");
        }
        if (minutes != 0L) {
            sb.append(" ").append(minutes).append("m");
        }
        if (seconds != 0L) {
            sb.append(" ").append(seconds).append("s");
        }
        return sb.toString().trim();
    }

    public static long parseTime(String input) {
        long result = 0L;
        StringBuilder number = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (Character.isDigit(c)) {
                number.append(c);
                continue;
            }
            if (!Character.isLetter(c) || number.length() <= 0) continue;
            result += TimeUtils.convert(Integer.parseInt(number.toString()), c);
            number = new StringBuilder();
        }
        return result;
    }

    private static long convert(long value, char unit) {
        switch (unit) {
            case 'd': {
                return value * 1000L * 60L * 60L * 24L;
            }
            case 'h': {
                return value * 1000L * 60L * 60L;
            }
            case 'm': {
                return value * 1000L * 60L;
            }
            case 's': {
                return value * 1000L;
            }
        }
        return 0L;
    }
}

