/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class TextUtils {
    private static final List<Charset> SUPPORTED_CHARSETS = new ArrayList<Charset>();

    public static String formatText(String text) {
        return TextUtils.formatText(text, false);
    }

    public static String formatText(String text, boolean capitalize) {
        if (text == null || text.isEmpty()) {
            return "";
        }
        if (capitalize) {
            text = text.substring(0, 1).toUpperCase() + text.substring(1);
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static List<String> formatText(List<String> list) {
        return list.stream().map(TextUtils::formatText).collect(Collectors.toList());
    }

    public static List<String> formatText(String ... list) {
        return Arrays.stream(list).map(TextUtils::formatText).collect(Collectors.toList());
    }

    public static List<String> wrap(String line) {
        return TextUtils.wrap(null, line);
    }

    public static List<String> wrap(String color, String line) {
        color = color != null ? "&" + color : "";
        ArrayList<String> lore = new ArrayList<String>();
        int lastIndex = 0;
        for (int n = 0; n < line.length(); ++n) {
            if (n - lastIndex < 25 || line.charAt(n) != ' ') continue;
            lore.add(TextUtils.formatText(color + TextUtils.formatText(line.substring(lastIndex, n))));
            lastIndex = n;
        }
        if (lastIndex - line.length() < 25) {
            lore.add(TextUtils.formatText(color + TextUtils.formatText(line.substring(lastIndex))));
        }
        return lore;
    }

    public static String convertToInvisibleLoreString(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        StringBuilder hidden = new StringBuilder();
        for (char c : s.toCharArray()) {
            hidden.append('\u00a7').append(';').append('\u00a7').append(c);
        }
        return hidden.toString();
    }

    public static String convertToInvisibleString(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        StringBuilder hidden = new StringBuilder();
        for (char c : s.toCharArray()) {
            hidden.append('\u00a7').append(c);
        }
        return hidden.toString();
    }

    public static String convertFromInvisibleString(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        return s.replaceAll("\u00a7;\u00a7|\u00a7", "");
    }

    public static Charset detectCharset(File file, Charset def) {
        int len;
        byte[] buffer = new byte[2048];
        try (FileInputStream input = new FileInputStream(file);){
            len = input.read(buffer);
        }
        catch (Exception ex) {
            return null;
        }
        return len != -1 ? TextUtils.detectCharset(buffer, len, def) : def;
    }

    public static Charset detectCharset(BufferedInputStream reader, Charset def) {
        int len;
        byte[] buffer = new byte[2048];
        try {
            reader.mark(2048);
            len = reader.read(buffer);
            reader.reset();
        }
        catch (Exception ex) {
            return null;
        }
        return len != -1 ? TextUtils.detectCharset(buffer, len, def) : def;
    }

    public static Charset detectCharset(byte[] data, int len, Charset def) {
        int newLen;
        if (len > 4) {
            if (data[0] == -1 && data[1] == -2) {
                return StandardCharsets.UTF_16LE;
            }
            if (data[0] == -2 && data[1] == -1) {
                return StandardCharsets.UTF_16BE;
            }
            if (data[0] == -17 && data[1] == -69 && data[2] == -65) {
                return StandardCharsets.UTF_8;
            }
        }
        for (newLen = len; newLen > 0 && !Character.isWhitespace(data[newLen - 1]); --newLen) {
        }
        if (len > 512 && newLen < 512) {
            newLen = len;
        }
        ByteBuffer bBuff = ByteBuffer.wrap(data, 0, newLen).asReadOnlyBuffer();
        for (Charset charset : SUPPORTED_CHARSETS) {
            if (charset != null && TextUtils.isCharset(bBuff, charset)) {
                return charset;
            }
            bBuff.rewind();
        }
        return def;
    }

    public static boolean isCharset(ByteBuffer data, Charset charset) {
        CharsetDecoder decoder = charset.newDecoder();
        decoder.onMalformedInput(CodingErrorAction.REPORT);
        decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        return decoder.decode(data, CharBuffer.allocate(data.capacity()), true).isUnderflow();
    }

    static {
        SUPPORTED_CHARSETS.add(StandardCharsets.UTF_8);
        SUPPORTED_CHARSETS.add(StandardCharsets.ISO_8859_1);
        try {
            SUPPORTED_CHARSETS.add(Charset.forName("windows-1253"));
            SUPPORTED_CHARSETS.add(Charset.forName("ISO-8859-7"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        SUPPORTED_CHARSETS.add(StandardCharsets.US_ASCII);
    }
}

