/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.permissions.PermissionAttachmentInfo;

public class PlayerUtils {
    public static void sendMessages(Player player, String ... messages) {
        for (String message : messages) {
            player.sendMessage(message);
        }
    }

    public static void sendMessages(Player player, List<String> messages) {
        PlayerUtils.sendMessages(player, messages.toArray(new String[0]));
    }

    @Deprecated
    public static List<String> getVisiblePlayerNames(CommandSender sender, String startingWith) {
        Player player = sender instanceof Player ? (Player)sender : null;
        String startsWith = startingWith == null || startingWith.isEmpty() ? null : startingWith.toLowerCase();
        return Bukkit.getOnlinePlayers().stream().filter(p -> p != player).filter(p -> startsWith == null || p.getName().toLowerCase().startsWith(startsWith)).filter(p -> player == null || player.canSee(p) && p.getMetadata("vanished").isEmpty()).map(Player::getName).collect(Collectors.toList());
    }

    @Deprecated
    public static List<String> getVisiblePlayerDisplayNames(CommandSender sender, String startingWith) {
        Player player = sender instanceof Player ? (Player)sender : null;
        String startsWith = startingWith == null || startingWith.isEmpty() ? null : startingWith.replaceAll("[^a-zA-Z]", "").toLowerCase();
        return Bukkit.getOnlinePlayers().stream().filter(p -> p != player).filter(p -> startsWith == null || p.getDisplayName().replaceAll("[^a-zA-Z]", "").toLowerCase().startsWith(startsWith)).filter(p -> player == null || player.canSee(p) && p.getMetadata("vanished").isEmpty()).map(Player::getDisplayName).collect(Collectors.toList());
    }

    @Deprecated
    public static List<Player> getVisiblePlayers(CommandSender sender, String startingWith) {
        Player player = sender instanceof Player ? (Player)sender : null;
        String startsWith = startingWith == null || startingWith.isEmpty() ? null : startingWith.toLowerCase();
        return Bukkit.getOnlinePlayers().stream().filter(p -> p != player).filter(p -> startsWith == null || p.getName().toLowerCase().startsWith(startsWith)).filter(p -> player == null || player.canSee(p) && p.getMetadata("vanished").isEmpty()).map(Player.class::cast).collect(Collectors.toList());
    }

    @Deprecated
    public static List<String> getAllPlayers(CommandSender us, String startsWith) {
        String arg = startsWith.toLowerCase();
        return Bukkit.getOnlinePlayers().stream().filter(p -> us != p && p.getName().startsWith(arg)).map(Player::getName).collect(Collectors.toList());
    }

    @Deprecated
    public static List<String> getAllPlayersDisplay(CommandSender us, String startsWith) {
        String arg = startsWith.replaceAll("[^a-zA-Z]", "").toLowerCase();
        return Bukkit.getOnlinePlayers().stream().filter(p -> us != p && p.getDisplayName().replaceAll("[^a-zA-Z]", "").startsWith(arg)).map(Player::getDisplayName).collect(Collectors.toList());
    }

    @Deprecated
    public static Player findPlayer(String player) {
        Player found = Bukkit.getServer().getPlayer(player);
        if (found == null) {
            String searchName = player.toLowerCase();
            String searchDisplayName = player.replaceAll("[^a-zA-Z]", "").toLowerCase();
            int d = 999;
            for (Player p2 : Bukkit.getOnlinePlayers()) {
                int d2;
                if (p2.getName().toLowerCase().startsWith(searchName)) {
                    d2 = p2.getName().length() - searchName.length();
                    if (d2 < d) {
                        found = p2;
                        d = d2;
                        continue;
                    }
                    if (d2 != d) continue;
                    found = null;
                    continue;
                }
                String test = p2.getDisplayName().replaceAll("[^a-zA-Z]", "");
                if (!test.toLowerCase().startsWith(searchDisplayName)) continue;
                d2 = test.length() - searchDisplayName.length();
                if (d2 < d) {
                    found = p2;
                    d = d2;
                    continue;
                }
                if (d2 != d) continue;
                found = null;
            }
        }
        return found;
    }

    public static Player getRandomPlayer() {
        Collection all = Bukkit.getOnlinePlayers();
        if (all.isEmpty()) {
            return null;
        }
        Iterator alli = all.iterator();
        for (int pick = ThreadLocalRandom.current().nextInt(all.size()); pick > 0; --pick) {
            alli.next();
        }
        return (Player)alli.next();
    }

    public static void giveItem(Player player, ItemStack item) {
        if (player == null || !player.isOnline() || item == null) {
            return;
        }
        HashMap leftover = player.getInventory().addItem(new ItemStack[]{item});
        if (!leftover.isEmpty()) {
            leftover.values().forEach(it -> player.getWorld().dropItemNaturally(player.getLocation(), it));
        }
    }

    public static void giveItem(Player player, ItemStack ... items) {
        if (player == null || !player.isOnline() || items == null || items.length == 0) {
            return;
        }
        HashMap leftover = player.getInventory().addItem(items);
        if (!leftover.isEmpty()) {
            World world = player.getWorld();
            Location location = player.getLocation();
            leftover.values().forEach(it -> world.dropItemNaturally(location, it));
        }
    }

    public static void giveItem(Player player, Collection<ItemStack> items) {
        if (player == null || !player.isOnline() || items == null || items.isEmpty()) {
            return;
        }
        HashMap leftover = player.getInventory().addItem(items.toArray(new ItemStack[0]));
        if (!leftover.isEmpty()) {
            World world = player.getWorld();
            Location location = player.getLocation();
            leftover.values().forEach(it -> world.dropItemNaturally(location, it));
        }
    }

    @Deprecated
    public static int getNumberFromPermission(Player player, String permission, int def) {
        Set permissions = player.getEffectivePermissions();
        boolean set = false;
        int highest = 0;
        for (PermissionAttachmentInfo info : permissions) {
            int index;
            String perm = info.getPermission();
            if (!perm.startsWith(permission) || (index = perm.lastIndexOf(46)) == -1 || index == perm.length()) continue;
            String numStr = perm.substring(perm.lastIndexOf(46) + 1);
            if (numStr.equals("*")) {
                return def;
            }
            int number = Integer.parseInt(numStr);
            if (number < highest) continue;
            highest = number;
            set = true;
        }
        return set ? highest : def;
    }
}

