/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.thread;

import com.craftaro.core.thread.MonitoredThread;
import java.util.HashSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MonitoredThreadPool {
    private final HashSet<MonitoredThread> threads = new HashSet();
    private final String name;
    private final int size;
    private int latestThread = 1;
    private final int threadTimeout;
    private final TimeUnit threadTimeoutUnit;

    public MonitoredThreadPool(String name, int size, int timeout, TimeUnit timeUnit) {
        this.name = name;
        this.size = size;
        this.threadTimeout = timeout;
        this.threadTimeoutUnit = timeUnit;
        for (int i = 0; i < size; ++i) {
            this.createThread(name);
        }
    }

    public MonitoredThread createThread(String name) {
        MonitoredThread thread = new MonitoredThread((name + "-" + this.latestThread++).toLowerCase(), this.threadTimeout, this.threadTimeoutUnit);
        this.threads.add(thread);
        return thread;
    }

    public void execute(Runnable runnable) {
        this.execute(runnable, false);
    }

    public void execute(Runnable runnable, boolean nonDisruptable) {
        MonitoredThread thread = this.getHealthyThread();
        if (thread != null) {
            thread.execute(runnable, nonDisruptable);
        }
    }

    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        MonitoredThread thread = this.getHealthyThread();
        return thread == null ? null : thread.schedule(runnable, delay, timeUnit);
    }

    public ScheduledFuture<?> delay(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.schedule(runnable, delay, timeUnit);
    }

    private MonitoredThread getHealthyThread() {
        for (MonitoredThread thread : this.threads) {
            if (!thread.isRunning()) {
                return thread;
            }
            if (!thread.isStalled()) continue;
            thread.start();
            this.onStall();
            return thread;
        }
        return null;
    }

    public int getRunningThreads() {
        int runningThreads = 0;
        for (MonitoredThread thread : this.threads) {
            if (!thread.isRunning()) continue;
            ++runningThreads;
        }
        return runningThreads;
    }

    public void onStall() {
    }
}

