/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.third_party.com.georgev22.api.libraryloader;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class ClassLoaderAccess {
    private final Collection<URL> unopenedURLs;
    private final Collection<URL> pathURLs;
    private final ClassLoader classLoader;
    private static volatile Object theUnsafe;

    private static boolean isUnsafeAvailable() {
        return theUnsafe != null;
    }

    public ClassLoaderAccess(URLClassLoader classLoader) {
        Collection pathURLs;
        Collection unopenedURLs;
        this.classLoader = classLoader;
        try {
            Object ucp = this.fetchField(classLoader.getClass(), classLoader, "ucp");
            unopenedURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "unopenedUrls");
            pathURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "path");
        }
        catch (Throwable e) {
            try {
                Object ucp = this.fetchField(classLoader.getClass(), classLoader, "ucp");
                unopenedURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "urls");
                pathURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "path");
            }
            catch (Throwable e1) {
                unopenedURLs = null;
                pathURLs = null;
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
        this.unopenedURLs = unopenedURLs;
        this.pathURLs = pathURLs;
    }

    public ClassLoaderAccess(ClassLoader classLoader) {
        Collection pathURLs;
        Collection unopenedURLs;
        this.classLoader = classLoader;
        try {
            Object ucp = this.fetchField(classLoader.getClass().getSuperclass(), classLoader, "ucp");
            unopenedURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "unopenedUrls");
            pathURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "path");
        }
        catch (Throwable e) {
            try {
                Object ucp = this.fetchField(classLoader.getClass().getSuperclass(), classLoader, "ucp");
                unopenedURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "urls");
                pathURLs = (Collection)this.fetchField(ucp.getClass(), ucp, "path");
            }
            catch (Throwable e1) {
                unopenedURLs = null;
                pathURLs = null;
                e.printStackTrace();
                e1.printStackTrace();
            }
        }
        this.unopenedURLs = unopenedURLs;
        this.pathURLs = pathURLs;
    }

    public void add(@NotNull URL url) throws RuntimeException {
        if (this.unopenedURLs.contains(url) || this.pathURLs.contains(url)) {
            throw new RuntimeException("URL " + url + " already exists in the path");
        }
        this.unopenedURLs.add(url);
        this.pathURLs.add(url);
    }

    public void remove(@NotNull URL url) {
        this.unopenedURLs.remove(url);
        this.pathURLs.remove(url);
    }

    public Collection<URL> getPathURLs() {
        return this.pathURLs;
    }

    public Collection<URL> getUnopenedURLs() {
        return this.unopenedURLs;
    }

    public boolean contains(URL url) {
        if (this.unopenedURLs.contains(url)) {
            return true;
        }
        return this.pathURLs.contains(url);
    }

    public boolean contains( @NotNull LibraryLoader.Dependency dependency) throws URISyntaxException {
        return this.contains(dependency, this.unopenedURLs) | this.contains(dependency, this.pathURLs);
    }

    private boolean contains( @NotNull LibraryLoader.Dependency dependency, @NotNull Collection<URL> urls) throws URISyntaxException {
        for (URL url : urls) {
            String fileName = url.toURI().getPath().substring(url.toURI().getPath().lastIndexOf("\\") + 1);
            if (fileName.equalsIgnoreCase(dependency.artifactId + "-" + dependency.version + ".jar")) {
                return true;
            }
            if (fileName.replace("-" + dependency.version, "").equalsIgnoreCase(dependency.artifactId + ".jar")) {
                return true;
            }
            if (!fileName.contains(dependency.artifactId)) continue;
            return true;
        }
        return false;
    }

    private Object fetchField(Class<?> clazz, Object object, String name) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (ClassLoaderAccess.isUnsafeAvailable()) {
            Field field = clazz.getDeclaredField(name);
            long offset = (Long)this.fetchMethodAndInvoke(theUnsafe.getClass(), "objectFieldOffset", theUnsafe, new Object[]{field}, new Class[]{Field.class});
            return this.fetchMethodAndInvoke(theUnsafe.getClass(), "getObject", theUnsafe, new Object[]{object, offset}, new Class[]{Object.class, Long.TYPE});
        }
        try {
            Field field = clazz.getDeclaredField(name);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new UnsupportedOperationException();
        }
    }

    private Object fetchMethodAndInvoke(Class<?> clazz, String name, Object obj, Object[] arguments, Class<?>[] parameterTypes) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        return this.fetchMethod(clazz, name, parameterTypes).invoke(obj, arguments);
    }

    @NotNull
    private Method fetchMethod(@NotNull Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Method method = clazz.getDeclaredMethod(name, parameterTypes);
        if (!ClassLoaderAccess.isUnsafeAvailable()) {
            method.setAccessible(true);
        }
        return method;
    }

    public String toString() {
        return "ClassLoaderAccess{unopenedURLs=" + this.unopenedURLs + ", pathURLs=" + this.pathURLs + ", classLoader=" + this.classLoader.getClass().getPackage().getName() + "." + this.classLoader.getClass().getName() + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Class<ClassLoaderAccess> clazz = ClassLoaderAccess.class;
            synchronized (ClassLoaderAccess.class) {
                if (theUnsafe == null) {
                    Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
                    Field theUnsafeField = unsafeClass.getDeclaredField("theUnsafe");
                    theUnsafeField.setAccessible(true);
                    theUnsafe = theUnsafeField.get(null);
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            theUnsafe = null;
        }
        {
            return;
        }
    }
}

