/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.loot;

import com.craftaro.core.nms.Nms;
import com.craftaro.core.utils.TextUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.EnchantmentStorageMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class Loot {
    @SerializedName(value="Command")
    private String command;
    @SerializedName(value="xp")
    private int xp = 0;
    @SerializedName(value="Type")
    private XMaterial material;
    @SerializedName(value="Name")
    private String name = null;
    @SerializedName(value="Lore")
    private List<String> lore = null;
    @SerializedName(value="Enchantments")
    private Map<String, Integer> enchants = null;
    @SerializedName(value="Burned Type")
    private XMaterial burnedMaterial = null;
    @SerializedName(value="Chance")
    private double chance = 100.0;
    @SerializedName(value="Min")
    private int min = 1;
    @SerializedName(value="Max")
    private int max = 1;
    @SerializedName(value="Wielded Enchantment Chance Overrides")
    private Map<String, Double> enchantChances = null;
    @SerializedName(value="Damage Min")
    private Integer damageMin = null;
    @SerializedName(value="Damage Max")
    private Integer damageMax = null;
    @SerializedName(value="Looting")
    private boolean allowLootingEnchant = true;
    @SerializedName(value="Looting Chance Increase")
    private Double lootingIncrease;
    @SerializedName(value="Only Drop For")
    private List<EntityType> onlyDropFor;
    @SerializedName(value="Child Loot Drop Count Min")
    private Integer childDropCountMin;
    @SerializedName(value="Child Loot Drop Count Max")
    private Integer childDropCountMax;
    @SerializedName(value="Child Loot")
    private List<Loot> childLoot;
    private boolean requireCharged = false;

    public XMaterial getMaterial() {
        return this.material;
    }

    public void setMaterial(XMaterial material) {
        this.material = material;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public int getXp() {
        return this.xp;
    }

    public void setXp(int xp) {
        this.xp = xp;
    }

    public String getName() {
        return TextUtils.formatText(this.name);
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getLore() {
        if (this.lore == null) {
            return null;
        }
        ArrayList<String> lore = new ArrayList<String>();
        for (String line : this.lore) {
            lore.add(TextUtils.formatText(line));
        }
        return lore;
    }

    public void setLore(List<String> lore) {
        this.lore = new ArrayList<String>(lore);
    }

    public ItemStack getEnchants(ItemStack item) {
        if (this.enchants == null) {
            return null;
        }
        if (item.getType() == Material.ENCHANTED_BOOK) {
            EnchantmentStorageMeta meta = (EnchantmentStorageMeta)item.getItemMeta();
            for (Map.Entry<String, Integer> entry : this.enchants.entrySet()) {
                if (entry.getValue() == null) continue;
                if (entry.getKey().equalsIgnoreCase("RANDOM")) {
                    item = Nms.getImplementations().getItem().copyAndApplyRandomEnchantment(item, entry.getValue());
                    continue;
                }
                meta.addStoredEnchant(Enchantment.getByName((String)entry.getKey()), entry.getValue().intValue(), true);
            }
            item.setItemMeta((ItemMeta)meta);
            return item;
        }
        HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
        for (Map.Entry<String, Integer> entry : this.enchants.entrySet()) {
            if (entry.getValue() == null) continue;
            if (entry.getKey().equalsIgnoreCase("RANDOM")) {
                item = Nms.getImplementations().getItem().copyAndApplyRandomEnchantment(item, entry.getValue());
                continue;
            }
            enchants.put(Enchantment.getByName((String)entry.getKey()), entry.getValue());
        }
        item.addEnchantments(enchants);
        return item;
    }

    public void setEnchants(Map<String, Integer> enchants) {
        this.enchants = enchants;
    }

    public void setEnchantChances(Map<String, Double> enchants) {
        this.enchantChances = enchants;
    }

    public Map<String, Integer> getEnchants() {
        return this.enchants == null ? null : Collections.unmodifiableMap(this.enchants);
    }

    public XMaterial getBurnedMaterial() {
        return this.burnedMaterial;
    }

    public void setBurnedMaterial(XMaterial burnedMaterial) {
        this.burnedMaterial = burnedMaterial;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance;
    }

    public boolean runChance(int looting, ItemStack murderWeapon) {
        double chance = this.chance;
        if (this.enchantChances != null && murderWeapon != null && this.enchants != null) {
            for (Map.Entry entry : murderWeapon.getEnchantments().entrySet()) {
                String key = ((Enchantment)entry.getKey()).getName() + ":" + entry.getValue();
                if (!this.enchants.containsKey(key) || !(this.enchantChances.get(key) > chance)) continue;
                chance = this.enchantChances.get(key);
            }
        }
        return Math.random() * 100.0 - (chance + (this.lootingIncrease == null ? 1.0 : this.lootingIncrease * (double)looting)) < 0.0 || chance == 100.0;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getDamageMax() {
        return this.damageMax == null ? 0 : this.damageMax;
    }

    public void setDamageMax(int damageMax) {
        this.damageMax = damageMax;
    }

    public int getDamageMin() {
        return this.damageMin == null ? 0 : this.damageMin;
    }

    public void setDamageMin(int damageMin) {
        this.damageMin = damageMin;
    }

    public int getAmountToDrop(int looting) {
        return this.min == this.max ? this.max + this.getLooting(looting) : new Random().nextInt(this.max + this.getLooting(looting) - this.min + 1) + this.min;
    }

    public int getLooting(int looting) {
        return this.allowLootingEnchant ? looting : 0;
    }

    public boolean isAllowLootingEnchant() {
        return this.allowLootingEnchant;
    }

    public void setAllowLootingEnchant(boolean allowLootingEnchant) {
        this.allowLootingEnchant = allowLootingEnchant;
    }

    public void setLootingIncrease(double increase) {
        this.lootingIncrease = increase;
    }

    public void addChildLoots(Loot ... loots) {
        this.childDropCountMin = 1;
        this.childDropCountMax = 1;
        if (this.childLoot == null) {
            this.childLoot = new ArrayList<Loot>();
        }
        this.childLoot.addAll(Arrays.asList(loots));
    }

    public void removeChildLoot(Loot loot) {
        if (this.childLoot == null) {
            return;
        }
        this.childLoot.remove(loot);
    }

    public List<Loot> getChildLoot() {
        return this.childLoot == null ? new ArrayList<Loot>() : new ArrayList<Loot>(this.childLoot);
    }

    public List<EntityType> getOnlyDropFor() {
        return this.onlyDropFor == null ? new ArrayList<EntityType>() : new ArrayList<EntityType>(this.onlyDropFor);
    }

    public void addOnlyDropFor(EntityType ... types) {
        this.onlyDropFor = new ArrayList<EntityType>();
        this.onlyDropFor.addAll(Arrays.asList(types));
    }

    public void setOnlyDropFor(List<EntityType> types) {
        this.onlyDropFor = types;
    }

    public void setChildDropCountMin(int childDropCountMin) {
        this.childDropCountMin = childDropCountMin;
    }

    public void setChildDropCountMax(int childDropCountMax) {
        this.childDropCountMax = childDropCountMax;
    }

    public Integer getChildDropCountMin() {
        return this.childDropCountMin;
    }

    public Integer getChildDropCountMax() {
        return this.childDropCountMax;
    }

    public int getChildDropCount() {
        if (this.childDropCountMin == null || this.childDropCountMax == null) {
            return 0;
        }
        return new Random().nextInt(this.childDropCountMax - this.childDropCountMin + 1) + this.childDropCountMin;
    }

    public boolean isRequireCharged() {
        return this.requireCharged;
    }

    public void setRequireCharged(boolean requireCharged) {
        this.requireCharged = requireCharged;
    }
}

