/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.gui;

import com.craftaro.core.gui.AnvilGui;
import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.lootables.gui.GuiLootEditor;
import com.craftaro.core.lootables.loot.Loot;
import com.craftaro.core.utils.TextUtils;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.enchantments.Enchantment;

public class GuiEnchantEditor
extends Gui {
    private final Gui returnGui;
    private final Loot loot;

    public GuiEnchantEditor(Loot loot, Gui returnGui) {
        super(1, returnGui);
        this.returnGui = returnGui;
        this.loot = loot;
        this.setDefaultItem(null);
        this.setTitle("Enchantment Editor");
        this.paint();
    }

    public void paint() {
        HashMap lore = this.loot.getEnchants() == null ? new HashMap() : new HashMap<String, Integer>(this.loot.getEnchants());
        this.setButton(2, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText("&cBack"), new String[0]), event -> {
            this.guiManager.showGUI(event.player, this.returnGui);
            ((GuiLootEditor)this.returnGui).paint();
        });
        this.setButton(6, GuiUtils.createButtonItem(XMaterial.OAK_FENCE_GATE, TextUtils.formatText("&cBack"), new String[0]), event -> {
            this.guiManager.showGUI(event.player, this.returnGui);
            ((GuiLootEditor)this.returnGui).paint();
        });
        this.setButton(3, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText("&aAdd new line"), new String[0]), event -> {
            AnvilGui gui = new AnvilGui(event.player, (Gui)this);
            gui.setAction(e -> {
                if (Enchantment.getByName((String)gui.getInputText().toUpperCase().trim()) == null) {
                    e.player.sendMessage("That is not a valid enchantment.");
                    e.player.closeInventory();
                    return;
                }
                AnvilGui gui1 = new AnvilGui(event.player, (Gui)this);
                gui1.setAction(ee -> {
                    lore.put(gui.getInputText().toUpperCase().trim(), Integer.parseInt(gui1.getInputText().trim()));
                    this.loot.setEnchants(lore);
                    ee.player.closeInventory();
                    this.paint();
                });
                gui1.setTitle("Enter a level");
                this.guiManager.showGUI(event.player, gui1);
            });
            gui.setTitle("Enter an enchant");
            this.guiManager.showGUI(event.player, gui);
        });
        ArrayList<String> enchantments = new ArrayList<String>();
        String last = null;
        if (!lore.isEmpty()) {
            for (Map.Entry entry : lore.entrySet()) {
                last = (String)entry.getKey();
                enchantments.add("&6" + (String)entry.getKey() + " " + entry.getValue());
            }
        }
        this.setItem(4, GuiUtils.createButtonItem(XMaterial.WRITABLE_BOOK, TextUtils.formatText("&7Enchant Override:"), lore.isEmpty() ? TextUtils.formatText(Collections.singletonList("&cNo enchantments set...")) : TextUtils.formatText(enchantments)));
        String lastFinal = last;
        this.setButton(5, GuiUtils.createButtonItem(XMaterial.ARROW, TextUtils.formatText("&cRemove the last line"), new String[0]), event -> {
            lore.remove(lastFinal);
            this.loot.setEnchants(lore);
            this.paint();
        });
    }
}

