/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.lootables.gui;

import com.craftaro.core.compatibility.CompatibleMaterial;
import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.gui.events.GuiClickEvent;
import com.craftaro.core.lootables.gui.GuiLootableEditor;
import com.craftaro.core.lootables.loot.LootManager;
import com.craftaro.core.lootables.loot.Lootable;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Optional;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiEditor
extends Gui {
    private final LootManager lootManager;

    public GuiEditor(LootManager lootManager) {
        super(6);
        this.lootManager = lootManager;
        this.setDefaultItem(null);
        this.setTitle("Lootables Overview");
        this.paint();
    }

    private void paint() {
        if (this.inventory != null) {
            this.inventory.clear();
        }
        this.setActionForRange(0, 0, 5, 9, null);
        ArrayList<Lootable> lootables = new ArrayList<Lootable>(this.lootManager.getRegisteredLootables().values());
        double itemCount = lootables.size();
        this.pages = (int)Math.max(1.0, Math.ceil(itemCount / 36.0));
        if (this.page != 1) {
            this.setButton(5, 2, GuiUtils.createButtonItem(XMaterial.ARROW, "Back", new String[0]), (GuiClickEvent event) -> {
                --this.page;
                this.paint();
            });
        }
        if (this.page != this.pages) {
            this.setButton(5, 6, GuiUtils.createButtonItem(XMaterial.ARROW, "Next", new String[0]), (GuiClickEvent event) -> {
                ++this.page;
                this.paint();
            });
        }
        for (int i = 9; i < 45; ++i) {
            int current = (this.page - 1) * 36 - 9;
            if (current + i >= lootables.size()) {
                this.setItem(i, null);
                continue;
            }
            Lootable lootable = (Lootable)lootables.get(current + i);
            if (lootable == null) continue;
            this.setButton(i, this.getIcon(lootable.getKey()), event -> this.guiManager.showGUI(event.player, new GuiLootableEditor(this.lootManager, lootable, this)));
        }
    }

    public ItemStack getIcon(String key) {
        Optional<XMaterial> material;
        ItemStack stack = null;
        EntityType type = EntityType.fromName((String)key);
        if (type != null && (material = CompatibleMaterial.getSpawnEgg(type)).isPresent()) {
            stack = material.get().parseItem();
        }
        if (stack == null) {
            stack = XMaterial.GHAST_SPAWN_EGG.parseItem();
        }
        ItemMeta meta = stack.getItemMeta();
        meta.setDisplayName(key);
        stack.setItemMeta(meta);
        return stack;
    }
}

