/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.http.minecraft;

import com.craftaro.core.nms.Nms;
import com.craftaro.core.nms.entity.player.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UuidToProfileResult {
    private static final Pattern ADD_HYPHENS_TO_UUID = Pattern.compile("(\\w{8})(\\w{4})(\\w{4})(\\w{3})(\\w{12})");
    @Nullable
    private String id;
    @Nullable
    private String name;
    @NotNull
    private List<Property> properties = Collections.emptyList();
    @NotNull
    private List<String> profileActions = Collections.emptyList();

    @NotNull
    public UUID getId() {
        return UUID.fromString(ADD_HYPHENS_TO_UUID.matcher(Objects.requireNonNull(this.id)).replaceAll("$1-$2-$3-$4-$5"));
    }

    @NotNull
    public String getName() {
        return Objects.requireNonNull(this.name);
    }

    @NotNull
    public List<Property> getProperties() {
        return this.properties;
    }

    @NotNull
    public List<String> getProfileActions() {
        return this.profileActions;
    }

    @NotNull
    public GameProfile createGameProfile() {
        String textureValue = null;
        String textureSignature = null;
        for (Property property : this.properties) {
            if (!property.name.equals("textures")) continue;
            textureValue = property.value;
            textureSignature = property.signature;
        }
        return Nms.getImplementations().getPlayer().createProfile(this.getId(), this.getName(), textureValue, textureSignature);
    }

    public static class Property {
        private String name;
        private String value;
        @Nullable
        private String signature;
    }
}

