/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.gui;

import com.craftaro.core.chat.AdventureUtils;
import com.craftaro.core.compatibility.CompatibleMaterial;
import com.craftaro.core.locale.Message;
import com.craftaro.core.third_party.net.kyori.adventure.text.Component;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GuiUtils {
    public static ItemStack getBorderGlassItem() {
        ItemStack glass = XMaterial.LIGHT_BLUE_STAINED_GLASS_PANE.parseItem();
        ItemMeta glassmeta = glass.getItemMeta();
        glassmeta.setDisplayName(ChatColor.BLACK.toString());
        glass.setItemMeta(glassmeta);
        return glass;
    }

    public static ItemStack getBorderItem(ItemStack item) {
        ItemMeta glassmeta = item.getItemMeta();
        glassmeta.setDisplayName(ChatColor.BLACK.toString());
        item.setItemMeta(glassmeta);
        return item;
    }

    public static ItemStack getBorderItem(XMaterial mat) {
        ItemStack item = mat.parseItem();
        ItemMeta glassmeta = item.getItemMeta();
        glassmeta.setDisplayName(ChatColor.BLACK.toString());
        item.setItemMeta(glassmeta);
        return item;
    }

    public static List<String> getSafeLore(String ... lines) {
        return GuiUtils.getSafeLore(Arrays.asList(lines));
    }

    public static List<String> getSafeLore(List<String> lines) {
        ArrayList<String> newLore = new ArrayList<String>();
        for (String line : lines) {
            for (String l2 : line.split("\n")) {
                if (l2.length() < 54) {
                    newLore.add(l2);
                    continue;
                }
                String shorterString = l2;
                ChatColor lastColor = null;
                int lineNumber = 0;
                while (shorterString.length() > 50) {
                    int breakingSpace = -1;
                    for (int i = 0; i < 50; ++i) {
                        if (shorterString.charAt(i) == '\u00a7') {
                            lastColor = ChatColor.getByChar((char)shorterString.charAt(++i));
                            continue;
                        }
                        if (shorterString.charAt(i) != ' ' && shorterString.charAt(i) != '-') continue;
                        breakingSpace = i;
                    }
                    if (breakingSpace == -1) {
                        breakingSpace = Math.max(50, shorterString.length());
                        newLore.add((lineNumber != 0 && lastColor != null ? lastColor.toString() : "") + shorterString.substring(0, breakingSpace) + "-");
                        shorterString = breakingSpace == shorterString.length() ? "" : shorterString.substring(breakingSpace + 1);
                    } else {
                        newLore.add((lineNumber != 0 && lastColor != null ? lastColor.toString() : "") + shorterString.substring(0, breakingSpace));
                        shorterString = breakingSpace == shorterString.length() ? "" : shorterString.substring(breakingSpace + 1);
                    }
                    ++lineNumber;
                }
                if (shorterString.isEmpty()) continue;
                newLore.add((lineNumber != 0 && lastColor != null ? lastColor.toString() : "") + "   " + shorterString);
            }
        }
        return newLore;
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, String title, String ... lore) {
        ItemStack item = mat.parseItem();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, Component title, Component ... lore) {
        return GuiUtils.createButtonItem(mat, 1, title, lore);
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, int amount, String title, String ... lore) {
        ItemStack item = mat.parseItem();
        item.setAmount(amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, int amount, Component title, Component ... lore) {
        ItemStack item = mat.parseItem();
        if (item == null) {
            throw new IllegalArgumentException("Invalid material: " + (Object)((Object)mat));
        }
        item.setAmount(amount);
        AdventureUtils.formatItemName(item, title);
        AdventureUtils.formatItemLore(item, lore);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(ItemStack from, String title, String ... lore) {
        ItemStack item = from.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, String title, List<String> lore) {
        ItemStack item = mat.parseItem();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, Component title, List<Component> lore) {
        return GuiUtils.createButtonItem(mat, 1, title, lore);
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, int amount, String title, List<String> lore) {
        ItemStack item = mat.parseItem();
        item.setAmount(amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, int amount, Component title, List<Component> lore) {
        ItemStack item = mat.parseItem();
        if (item == null) {
            throw new IllegalArgumentException("Invalid material: " + (Object)((Object)mat));
        }
        item.setAmount(amount);
        AdventureUtils.formatItemName(item, title);
        AdventureUtils.formatItemLore(item, lore, new String[0]);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(ItemStack from, String title, List<String> lore) {
        ItemStack item = from.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(ItemStack from, Component title, List<Component> lore) {
        ItemStack item = from.clone();
        AdventureUtils.formatItemName(item, title);
        AdventureUtils.formatItemLore(item, lore, new String[0]);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, String[] lore) {
        ItemStack item = mat.parseItem();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && lore.length != 0) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, int amount, String[] lore) {
        ItemStack item = mat.parseItem();
        item.setAmount(amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && lore.length != 0) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, int amount, Component ... lore) {
        ItemStack item = mat.parseItem();
        if (item == null) {
            throw new IllegalArgumentException("Invalid material: " + (Object)((Object)mat));
        }
        item.setAmount(amount);
        AdventureUtils.formatItemLore(item, lore);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(ItemStack from, String[] lore) {
        ItemStack item = from.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && lore.length != 0) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(ItemStack from, Component ... lore) {
        ItemStack item = from.clone();
        AdventureUtils.formatItemLore(item, lore);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, List<String> lore, String ... unused) {
        ItemStack item = mat.parseItem();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && !lore.isEmpty()) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, List<Component> lore) {
        return GuiUtils.createButtonItem(mat, 1, lore);
    }

    @Deprecated
    public static ItemStack createButtonItem(XMaterial mat, int amount, List<String> lore, String ... unused) {
        ItemStack item = mat.parseItem();
        item.setAmount(amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && !lore.isEmpty()) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial mat, int amount, List<Component> lore) {
        ItemStack item = mat.parseItem();
        if (item == null) {
            throw new IllegalArgumentException("Invalid material: " + (Object)((Object)mat));
        }
        item.setAmount(amount);
        AdventureUtils.formatItemLore(item, lore, new String[0]);
        return item;
    }

    @Deprecated
    public static ItemStack createButtonItem(ItemStack from, List<String> lore, String ... unused) {
        ItemStack item = from.clone();
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && !lore.isEmpty()) {
                List<String> safe = GuiUtils.getSafeLore(lore);
                meta.setDisplayName(safe.get(0));
                meta.setLore(safe.subList(1, safe.size()));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack createButtonItem(ItemStack from, List<Component> lore) {
        ItemStack item = from.clone();
        AdventureUtils.formatItemLore(item, lore, new String[0]);
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, String title, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, Component title, Component ... lore) {
        AdventureUtils.formatItemName(item, title);
        AdventureUtils.formatItemLore(item, lore);
        return item;
    }

    @Deprecated
    public static ItemStack updateItemName(ItemStack item, String title) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItemName(ItemStack item, Component title) {
        AdventureUtils.formatItemName(item, title);
        return item;
    }

    @Deprecated
    public static ItemStack updateItemLore(ItemStack item, String ... lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null && lore.length != 0) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItemLore(ItemStack item, Component ... lore) {
        AdventureUtils.formatItemLore(item, lore);
        return item;
    }

    @Deprecated
    public static ItemStack updateItemLore(ItemStack item, List<String> lore, String ... unused) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItemLore(ItemStack item, List<Component> lore) {
        AdventureUtils.formatItemLore(item, lore, new String[0]);
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, XMaterial matTo, String title, String ... lore) {
        ItemMeta meta;
        if (!matTo.isSimilar(item)) {
            item = matTo.parseItem();
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, XMaterial matTo, Component title, Component ... lore) {
        ItemMeta meta;
        if (!matTo.isSimilar(item)) {
            item = matTo.parseItem();
        }
        if ((meta = item.getItemMeta()) != null) {
            AdventureUtils.formatItemName(item, title);
            AdventureUtils.formatItemLore(item, lore);
        }
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, ItemStack to, String title, String ... lore) {
        ItemMeta meta;
        if (!CompatibleMaterial.getMaterial(item.getType()).get().isSimilar(to)) {
            item = to.clone();
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, ItemStack to, Component title, Component ... lore) {
        ItemMeta meta;
        if (!CompatibleMaterial.getMaterial(item.getType()).get().isSimilar(to)) {
            item = to.clone();
        }
        if ((meta = item.getItemMeta()) != null) {
            AdventureUtils.formatItemName(item, title);
            AdventureUtils.formatItemLore(item, lore);
        }
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, String title, List<String> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, Component title, List<Component> lore) {
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            AdventureUtils.formatItemName(item, title);
            AdventureUtils.formatItemLore(item, lore, new String[0]);
        }
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, XMaterial matTo, String title, List<String> lore) {
        ItemMeta meta;
        if (!matTo.isSimilar(item)) {
            item = matTo.parseItem();
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, XMaterial matTo, Component title, List<Component> lore) {
        ItemMeta meta;
        if (!matTo.isSimilar(item)) {
            item = matTo.parseItem();
        }
        if ((meta = item.getItemMeta()) != null) {
            AdventureUtils.formatItemName(item, title);
            AdventureUtils.formatItemLore(item, lore, new String[0]);
        }
        return item;
    }

    @Deprecated
    public static ItemStack updateItem(ItemStack item, ItemStack to, String title, List<String> lore) {
        ItemMeta meta;
        if (!CompatibleMaterial.getMaterial(item.getType()).get().isSimilar(to)) {
            item = to.clone();
        }
        if ((meta = item.getItemMeta()) != null) {
            meta.setDisplayName(title);
            if (lore != null) {
                meta.setLore(GuiUtils.getSafeLore(lore));
            } else {
                meta.setLore(Collections.emptyList());
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public static ItemStack updateItem(ItemStack item, ItemStack to, Component title, List<Component> lore) {
        ItemMeta meta;
        if (!CompatibleMaterial.getMaterial(item.getType()).get().isSimilar(to)) {
            item = to.clone();
        }
        if ((meta = item.getItemMeta()) != null) {
            AdventureUtils.formatItemName(item, title);
            AdventureUtils.formatItemLore(item, lore, new String[0]);
        }
        return item;
    }

    public static ItemStack createButtonItem(XMaterial material, Message title) {
        return GuiUtils.createButtonItem(material, title.getMessage(), new Component[0]);
    }

    public static ItemStack createButtonItem(XMaterial material, Message title, Message lore) {
        return GuiUtils.createButtonItem(material, title.getMessage(), lore.getMessage());
    }
}

