/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.gui;

import com.craftaro.core.gui.Gui;
import com.craftaro.core.gui.GuiHolder;
import com.craftaro.core.gui.GuiManager;
import com.craftaro.core.gui.GuiUtils;
import com.craftaro.core.gui.methods.Clickable;
import com.craftaro.core.nms.Nms;
import com.craftaro.core.nms.anvil.AnvilCore;
import com.craftaro.core.nms.anvil.CustomAnvil;
import com.craftaro.third_party.com.cryptomorin.xseries.XMaterial;
import java.util.Arrays;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnvilGui
extends Gui {
    final Player player;
    CustomAnvil anvil;
    List<String> endPrompt = null;

    public AnvilGui(Player player) {
        this.player = player;
    }

    public AnvilGui(Player player, Gui parent) {
        super(parent);
        this.player = player;
    }

    @NotNull
    public AnvilGui setAction(@Nullable Clickable action) {
        return (AnvilGui)this.setAction(2, action);
    }

    @NotNull
    public AnvilGui setAction(@Nullable ClickType type, @Nullable Clickable action) {
        return (AnvilGui)this.setAction(2, type, action);
    }

    protected void open() {
        this.anvil.open();
    }

    public AnvilGui setInput(ItemStack item) {
        return (AnvilGui)this.setItem(0, item);
    }

    public ItemStack getInput() {
        return this.getItem(0);
    }

    public AnvilGui setOutput(ItemStack item) {
        return (AnvilGui)this.setItem(2, item);
    }

    public AnvilGui setOutputPrompt(String str) {
        this.endPrompt = Arrays.asList(str);
        return this;
    }

    public AnvilGui setOutputPrompt(String ... str) {
        this.endPrompt = Arrays.asList(str);
        return this;
    }

    public AnvilGui setOutputPrompt(List<String> str) {
        this.endPrompt = str;
        return this;
    }

    void updateOutputPrompt() {
        ItemStack in;
        if (this.endPrompt != null && (in = (ItemStack)this.cellItems.get(0)) != null) {
            this.setItem(2, GuiUtils.createButtonItem(in, this.endPrompt, new String[0]));
        }
    }

    public ItemStack getOutput() {
        return this.getItem(2);
    }

    public String getInputText() {
        return this.anvil != null ? this.anvil.getRenameText() : null;
    }

    @Override
    @NotNull
    protected Inventory generateInventory(@NotNull GuiManager manager) {
        ItemStack item;
        this.guiManager = manager;
        this.createInventory();
        if (this.cellItems.containsKey(0)) {
            item = (ItemStack)this.cellItems.get(0);
            this.inventory.setItem(0, item);
        } else if (this.cellItems.containsKey(1)) {
            item = (ItemStack)this.cellItems.get(1);
            this.inventory.setItem(1, item);
        } else if (!this.acceptsItems) {
            item = GuiUtils.createButtonItem(XMaterial.PAPER, " ", " ");
            this.cellItems.put(0, item);
            this.inventory.setItem(0, item);
        }
        if (this.cellItems.containsKey(2)) {
            item = (ItemStack)this.cellItems.get(2);
            this.inventory.setItem(2, item);
        }
        return this.inventory;
    }

    @Override
    protected void createInventory() {
        AnvilCore nms = Nms.getImplementations().getAnvil();
        this.anvil = nms.createAnvil(this.player, new GuiHolder(this.guiManager, this));
        this.anvil.setCustomTitle(this.title);
        this.anvil.setLevelCost(0);
        this.inventory = this.anvil.getInventory();
        this.anvil.setOnChange(this::updateOutputPrompt);
    }
}

