/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.dependency;

import com.craftaro.core.CraftaroCoreConstants;
import com.craftaro.core.SongodaCore;
import com.craftaro.core.dependency.Dependency;
import com.craftaro.core.dependency.Relocation;
import com.craftaro.core.third_party.com.georgev22.api.libraryloader.ClassLoaderAccess;
import com.craftaro.core.third_party.com.georgev22.api.libraryloader.LibraryLoader;
import com.craftaro.core.third_party.me.lucko.jarrelocator.JarRelocator;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.bukkit.plugin.Plugin;

public class DependencyLoader {
    private static final int DEPENDENCY_VERSION = 1;
    private final LibraryLoader libraryLoader;
    private final ClassLoaderAccess parentClassLoaderAccess;

    public DependencyLoader(Plugin plugin) {
        ClassLoader parentClassLoader = plugin.getClass().getClassLoader().getParent();
        if (parentClassLoader instanceof URLClassLoader) {
            this.libraryLoader = new LibraryLoader((URLClassLoader)parentClassLoader, new File(plugin.getDataFolder().getParentFile(), CraftaroCoreConstants.getProjectName() + "/dependencies/v" + 1), (Logger)SongodaCore.getLogger());
            this.parentClassLoaderAccess = new ClassLoaderAccess((URLClassLoader)parentClassLoader);
        } else {
            this.libraryLoader = new LibraryLoader(parentClassLoader, new File(plugin.getDataFolder().getParentFile(), CraftaroCoreConstants.getProjectName() + "/dependencies/v" + 1), (Logger)SongodaCore.getLogger());
            this.parentClassLoaderAccess = new ClassLoaderAccess(parentClassLoader);
        }
    }

    public void loadDependencies(Collection<Dependency> dependencies) throws IOException {
        for (Dependency dependency : dependencies) {
            this.loadDependency(dependency);
        }
    }

    public void loadDependency(Dependency dependency) throws IOException {
        String name = dependency.getArtifactId() + "-" + dependency.getVersion();
        File outputFile = new File(this.libraryLoader.getLibFolder(), dependency.getGroupId().replace(".", File.separator) + File.separator + dependency.getArtifactId().replace(".", File.separator) + File.separator + dependency.getVersion() + File.separator + "raw-" + name + ".jar");
        File relocatedFile = new File(outputFile.getParentFile(), name.replace("raw-", "") + ".jar");
        if (relocatedFile.exists()) {
            if (this.isJarLoaded(relocatedFile)) {
                return;
            }
            this.loadJarIntoClasspath(relocatedFile, dependency);
            return;
        }
        SongodaCore.getLogger().info(String.format("Downloading dependency %s:%s:%s from %s", dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getRepositoryUrl()));
        Files.createDirectories(outputFile.getParentFile().toPath(), new FileAttribute[0]);
        try (InputStream is = new URL(dependency.buildArtifactUrl()).openStream();){
            Files.copy(is, outputFile.toPath(), new CopyOption[0]);
        }
        this.loadJarIntoClasspath(outputFile, dependency);
    }

    public void loadJarIntoClasspath(File file, Dependency dependency) throws IOException {
        if (!this.isRelocated(file) && dependency.shouldRelocate()) {
            SongodaCore.getLogger().info("Loading dependency for relocation " + file);
            ArrayList<com.craftaro.core.third_party.me.lucko.jarrelocator.Relocation> relocations = new ArrayList<com.craftaro.core.third_party.me.lucko.jarrelocator.Relocation>();
            for (Relocation r : dependency.getRelocations()) {
                relocations.add(new com.craftaro.core.third_party.me.lucko.jarrelocator.Relocation(r.getFrom(), r.getTo()));
            }
            File finalJar = new File(file.getParentFile(), file.getName().replace("raw-", ""));
            JarRelocator relocator = new JarRelocator(file, finalJar, relocations);
            try {
                relocator.run();
                SongodaCore.getLogger().info("Relocated dependency " + file);
                Files.deleteIfExists(file.toPath());
            }
            catch (Exception e) {
                SongodaCore.getLogger().severe("Failed to relocate dependency " + file);
                if (e.getMessage().contains("zip file is empty")) {
                    SongodaCore.getLogger().severe("Try deleting '" + this.libraryLoader.getLibFolder().getParent() + "' and restarting the server");
                }
                Files.deleteIfExists(finalJar.toPath());
                throw e;
            }
        }
        try {
            this.libraryLoader.load(new LibraryLoader.Dependency(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion(), dependency.getRepositoryUrl()), false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        SongodaCore.getLogger().info("----------------------------");
    }

    private boolean isRelocated(File jarFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(jarFile);){
            Enumeration<? extends ZipEntry> zipEntries = zipFile.entries();
            while (zipEntries.hasMoreElements()) {
                ZipEntry entry = zipEntries.nextElement();
                if (!entry.getName().startsWith("com/craftaro/third_party")) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean isJarLoaded(File jarFile) throws IOException {
        URL jarFileURL = jarFile.toURI().toURL();
        try {
            return this.parentClassLoaderAccess.getPathURLs().stream().anyMatch(url -> url.getFile().equals(jarFileURL.getFile()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static int getDependencyVersion() {
        return 1;
    }
}

