/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.dependency;

import com.craftaro.core.dependency.Relocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Dependency {
    private final String repositoryUrl;
    private final String groupId;
    private final String artifactId;
    private final String version;
    private boolean relocate;
    private final List<Relocation> relocations = new ArrayList<Relocation>();

    public Dependency(String repositoryUrl, String groupId, String artifactId, String version) {
        this(repositoryUrl, groupId, artifactId, version, true);
    }

    public Dependency(String repositoryUrl, String groupId, String artifactId, String version, boolean baseRelocate) {
        this(repositoryUrl, groupId, artifactId, version, baseRelocate, new Relocation[0]);
    }

    public Dependency(String repositoryUrl, String groupId, String artifactId, String version, boolean baseRelocate, Relocation ... extraRelocations) {
        this.repositoryUrl = repositoryUrl;
        this.groupId = groupId.replaceAll(";", ".");
        this.artifactId = artifactId;
        this.version = version;
        if (baseRelocate) {
            this.relocations.add(new Relocation(groupId, "com.craftaro.third_party." + groupId));
        }
        if (extraRelocations.length > 0) {
            this.relocations.addAll(Arrays.asList(extraRelocations));
        }
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public List<Relocation> getRelocations() {
        return this.relocations;
    }

    public boolean shouldRelocate() {
        return this.relocate || !this.relocations.isEmpty();
    }

    public String buildArtifactUrl() {
        return this.repositoryUrl + "/" + this.groupId.replace('.', '/') + "/" + this.artifactId + "/" + this.version + "/" + this.artifactId + "-" + this.version + ".jar";
    }
}

