/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.database;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;

public class SerializedLocation {
    private final String world;
    private final double x;
    private final double y;
    private final double z;
    private final float pitch;
    private final float yaw;

    public SerializedLocation(Location location) {
        this.world = location.getWorld().getName();
        this.x = location.getX();
        this.y = location.getY();
        this.z = location.getZ();
        if (location.getPitch() != 0.0f && location.getYaw() != 0.0f) {
            this.pitch = location.getPitch();
            this.yaw = location.getYaw();
        } else {
            this.pitch = 0.0f;
            this.yaw = 0.0f;
        }
    }

    public static Location of(Map<String, Object> map) {
        return new Location(Bukkit.getWorld((String)((String)map.get("world"))), ((Double)map.get("x")).doubleValue(), ((Double)map.get("y")).doubleValue(), ((Double)map.get("z")).doubleValue(), Double.valueOf((Double)map.getOrDefault("yaw", 0.0)).floatValue(), Double.valueOf((Double)map.getOrDefault("pitch", 0.0)).floatValue());
    }

    public static Map<String, Object> of(Location location) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("world", location.getWorld().getName());
        map.put("x", location.getX());
        map.put("y", location.getY());
        map.put("z", location.getZ());
        if (location.getPitch() != 0.0f && location.getYaw() != 0.0f) {
            map.put("pitch", Float.valueOf(location.getPitch()));
            map.put("yaw", Float.valueOf(location.getYaw()));
        }
        return map;
    }

    public Location asLocation() {
        return new Location(Bukkit.getWorld((String)this.world), this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("world", this.world);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("z", this.z);
        if (this.pitch != 0.0f && this.yaw != 0.0f) {
            map.put("pitch", Float.valueOf(this.pitch));
            map.put("yaw", Float.valueOf(this.yaw));
        }
        return map;
    }
}

