/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.database;

import com.craftaro.core.SongodaCore;
import com.craftaro.core.SongodaPlugin;
import com.craftaro.core.configuration.Config;
import com.craftaro.core.database.DatabaseConnector;
import com.craftaro.core.database.DatabaseType;
import com.craftaro.core.database.OptionalResult;
import com.craftaro.third_party.com.zaxxer.hikari.HikariConfig;
import com.craftaro.third_party.com.zaxxer.hikari.HikariDataSource;
import com.craftaro.third_party.org.jooq.SQLDialect;
import com.craftaro.third_party.org.jooq.impl.DSL;
import java.sql.Connection;
import java.sql.SQLException;
import org.bukkit.plugin.Plugin;

public class H2Connector
implements DatabaseConnector {
    private final Plugin plugin;
    private HikariDataSource hikari;
    private boolean initializedSuccessfully;

    H2Connector() {
        this.plugin = null;
        int poolSize = 2;
        String username = "username";
        String password = "password";
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("com.craftaro.third_party.org.h2.Driver");
        config.setJdbcUrl("jdbc:h2:./db_test/CraftaroCoreTest;AUTO_RECONNECT=TRUE;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(poolSize);
        try {
            this.hikari = new HikariDataSource(config);
            this.initializedSuccessfully = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.initializedSuccessfully = false;
        }
    }

    public H2Connector(SongodaPlugin plugin) {
        this((Plugin)plugin, plugin.getDatabaseConfig());
    }

    public H2Connector(Plugin plugin, Config databaseConfig) {
        this.plugin = plugin;
        int poolSize = databaseConfig.getInt("Connection Settings.Pool Size");
        String username = databaseConfig.getString("Connection Settings.Username");
        String password = databaseConfig.getString("Connection Settings.Password");
        HikariConfig config = new HikariConfig();
        config.setDriverClassName("com;craftaro;third_party;org;h2;Driver".replace(";", "."));
        config.setJdbcUrl("jdbc:h2:./" + plugin.getDataFolder().getPath().replaceAll("\\\\", "/") + "/" + plugin.getDescription().getName().toLowerCase() + ";AUTO_RECONNECT=TRUE;MODE=MySQL;DATABASE_TO_LOWER=TRUE;CASE_INSENSITIVE_IDENTIFIERS=TRUE");
        config.setUsername(username);
        config.setPassword(password);
        config.setMaximumPoolSize(poolSize);
        try {
            this.hikari = new HikariDataSource(config);
            this.initializedSuccessfully = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.initializedSuccessfully = false;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initializedSuccessfully;
    }

    @Override
    public void closeConnection() {
        this.hikari.close();
    }

    @Override
    public void connect(DatabaseConnector.ConnectionCallback callback) {
        try (Connection connection = this.hikari.getConnection();){
            callback.accept(connection);
        }
        catch (SQLException ex) {
            this.plugin.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public OptionalResult connectOptional(DatabaseConnector.ConnectionOptionalCallback callback) {
        OptionalResult optionalResult;
        block9: {
            Connection connection = this.getConnection();
            try {
                optionalResult = callback.accept(connection);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    if (this.plugin != null) {
                        SongodaCore.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
                    }
                    ex.printStackTrace();
                    return OptionalResult.empty();
                }
            }
            connection.close();
        }
        return optionalResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connectResult(DatabaseConnector.ConnectResult<T> callback, T ... defaultValue) {
        try (Connection connection = this.getConnection();){
            T result = callback.accept(connection);
            T t = result != null ? result : (defaultValue.length > 0 ? defaultValue[0] : null);
            return t;
        }
        catch (Exception ex) {
            T t;
            if (this.plugin != null) {
                SongodaCore.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
            }
            ex.printStackTrace();
            if (defaultValue.length > 0) {
                t = defaultValue[0];
                return t;
            }
            t = null;
            return t;
        }
    }

    @Override
    public void connectDSL(DatabaseConnector.DSLContextCallback callback) {
        try (Connection connection = this.getConnection();){
            callback.accept(DSL.using(connection, SQLDialect.MYSQL));
        }
        catch (Exception ex) {
            if (this.plugin != null) {
                this.plugin.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
            }
            ex.printStackTrace();
        }
    }

    @Override
    public OptionalResult connectDSLOptional(DatabaseConnector.DSLContextOptionalCallback callback) {
        OptionalResult optionalResult;
        block9: {
            Connection connection = this.getConnection();
            try {
                optionalResult = callback.accept(DSL.using(connection, SQLDialect.MYSQL));
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    if (this.plugin != null) {
                        SongodaCore.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
                    }
                    ex.printStackTrace();
                    return OptionalResult.empty();
                }
            }
            connection.close();
        }
        return optionalResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T connectDSLResult(DatabaseConnector.DSLConnectResult<T> callback, T ... defaultValue) {
        try (Connection connection = this.getConnection();){
            T result = callback.accept(DSL.using(connection, SQLDialect.MYSQL));
            T t = result != null ? result : (defaultValue.length > 0 ? defaultValue[0] : null);
            return t;
        }
        catch (Exception ex) {
            T t;
            if (this.plugin != null) {
                SongodaCore.getLogger().severe("An error occurred executing a H2 query: " + ex.getMessage());
            }
            ex.printStackTrace();
            if (defaultValue.length > 0) {
                t = defaultValue[0];
                return t;
            }
            t = null;
            return t;
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.hikari.getConnection();
    }

    @Override
    public DatabaseType getType() {
        return DatabaseType.H2;
    }
}

