/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.database;

import com.craftaro.core.SongodaPlugin;
import com.craftaro.core.configuration.Config;
import com.craftaro.core.database.Data;
import com.craftaro.core.database.DataMigration;
import com.craftaro.core.database.DatabaseConnector;
import com.craftaro.core.database.DatabaseType;
import com.craftaro.core.database.H2Connector;
import com.craftaro.core.database.MariaDBConnector;
import com.craftaro.core.database.MySQLConnector;
import com.craftaro.core.database.SQLiteConnector;
import com.craftaro.third_party.org.jooq.Condition;
import com.craftaro.third_party.org.jooq.Record;
import com.craftaro.third_party.org.jooq.SelectFieldOrAsterisk;
import com.craftaro.third_party.org.jooq.TableLike;
import com.craftaro.third_party.org.jooq.impl.DSL;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.bukkit.plugin.Plugin;

public class DataManager {
    protected final SongodaPlugin plugin;
    protected final Config databaseConfig;
    private final List<DataMigration> migrations;
    protected DatabaseConnector databaseConnector;
    protected DatabaseType type;
    private final Map<String, AtomicInteger> autoIncrementCache = new HashMap<String, AtomicInteger>();
    protected final ExecutorService asyncPool = new ThreadPoolExecutor(1, 5, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setNameFormat(this.getClass().getSimpleName() + "-Database-Async-%d").build());
    @Deprecated
    private static final Map<String, LinkedList<Runnable>> queues = new HashMap<String, LinkedList<Runnable>>();

    DataManager() {
        this.databaseConfig = null;
        this.plugin = null;
        this.migrations = Collections.emptyList();
        this.databaseConnector = new H2Connector();
    }

    DataManager(DatabaseType type) {
        this.databaseConfig = null;
        this.plugin = null;
        this.migrations = Collections.emptyList();
        this.databaseConnector = new SQLiteConnector();
    }

    public DataManager(SongodaPlugin plugin, List<DataMigration> migrations) {
        this(plugin, migrations, null);
    }

    public DataManager(SongodaPlugin plugin, List<DataMigration> migrations, DatabaseType forcedType) {
        this.plugin = plugin;
        this.migrations = migrations;
        this.databaseConfig = plugin.getDatabaseConfig();
        try {
            this.load(forcedType);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void load(DatabaseType forcedType) throws SQLException {
        String databaseType = this.databaseConfig.getString("Connection Settings.Type").toUpperCase();
        if (forcedType != null) {
            databaseType = forcedType.name();
        }
        switch (databaseType) {
            case "MYSQL": {
                this.databaseConnector = new MySQLConnector((Plugin)this.plugin, this.databaseConfig);
                break;
            }
            case "MARIADB": {
                this.databaseConnector = new MariaDBConnector(this.plugin, this.databaseConfig);
                break;
            }
            case "SQLITE": {
                this.databaseConnector = new SQLiteConnector((Plugin)this.plugin);
                break;
            }
            default: {
                this.databaseConnector = new H2Connector(this.plugin);
            }
        }
        this.type = this.databaseConnector.getType();
        this.plugin.getLogger().info("Data handler connected using " + this.databaseConnector.getType().name() + ".");
        this.runMigrations();
    }

    public DatabaseConnector getDatabaseConnector() {
        return this.databaseConnector;
    }

    public ExecutorService getAsyncPool() {
        return this.asyncPool;
    }

    public String getTablePrefix() {
        if (this.plugin == null) {
            return "";
        }
        return this.plugin.getDescription().getName().toLowerCase() + '_';
    }

    public void runMigrations() throws SQLException {
        try (Connection connection = this.databaseConnector.getConnection();){
            PreparedStatement statement;
            boolean migrationsExist;
            int currentMigration = -1;
            try {
                connection.createStatement().execute("SELECT 1 FROM " + this.getMigrationsTableName());
                migrationsExist = true;
            }
            catch (Exception ex) {
                migrationsExist = false;
            }
            if (!migrationsExist) {
                String createTable = "CREATE TABLE " + this.getMigrationsTableName() + " (migration_version INT NOT NULL)";
                statement = connection.prepareStatement(createTable);
                try {
                    statement.execute();
                }
                finally {
                    if (statement != null) {
                        statement.close();
                    }
                }
                String insertRow = "INSERT INTO " + this.getMigrationsTableName() + " VALUES (?)";
                try (PreparedStatement statement2 = connection.prepareStatement(insertRow);){
                    statement2.setInt(1, -1);
                    statement2.execute();
                }
            }
            String selectVersion = "SELECT migration_version FROM " + this.getMigrationsTableName() + " ORDER BY migration_version DESC LIMIT 1";
            statement = connection.prepareStatement(selectVersion);
            try {
                ResultSet result = statement.executeQuery();
                result.next();
                currentMigration = result.getInt("migration_version");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
            int finalCurrentMigration = currentMigration;
            List requiredMigrations = this.migrations.stream().filter(x -> x.getRevision() > finalCurrentMigration).sorted(Comparator.comparingInt(DataMigration::getRevision)).collect(Collectors.toList());
            if (requiredMigrations.isEmpty()) {
                return;
            }
            for (DataMigration dataMigration : requiredMigrations) {
                dataMigration.migrate(connection, this.getTablePrefix());
            }
            currentMigration = requiredMigrations.stream().map(DataMigration::getRevision).max(Integer::compareTo).orElse(-1);
            String updateVersion = "UPDATE " + this.getMigrationsTableName() + " SET migration_version = ?";
            try (PreparedStatement statement3 = connection.prepareStatement(updateVersion);){
                statement3.setInt(1, currentMigration);
                statement3.execute();
            }
        }
    }

    private String getMigrationsTableName() {
        return this.getTablePrefix() + "migrations";
    }

    public synchronized int getNextId(String table) {
        String prefixedTable = this.getTablePrefix() + table;
        if (!this.autoIncrementCache.containsKey(prefixedTable)) {
            this.databaseConnector.connectDSL(context -> {
                try {
                    Optional<Integer> max = context.select(DSL.max(DSL.field("id"))).from(prefixedTable).fetchOptional().map(record -> record.get(0, Integer.class));
                    this.autoIncrementCache.put(prefixedTable, new AtomicInteger(max.orElse(0)));
                }
                catch (Exception e) {
                    this.autoIncrementCache.put(prefixedTable, new AtomicInteger(0));
                }
            });
        }
        return this.autoIncrementCache.get(prefixedTable).incrementAndGet();
    }

    public void save(Data data) {
        this.asyncPool.execute(() -> this.saveSync(data));
    }

    public void save(Data data, String idField, Object idValue) {
        this.asyncPool.execute(() -> this.saveSync(data, idField, idValue));
    }

    public void saveSync(Data data, String idField, Object idValue) {
        this.databaseConnector.connectDSL(context -> context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(DSL.field(idField)).doUpdate().set(data.serialize()).where(DSL.field(idField).eq(idValue)).execute());
    }

    public void saveSync(Data data) {
        this.databaseConnector.connectDSL(context -> context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(data.getId() != -1 ? DSL.field("id") : DSL.field("uuid")).doUpdate().set(data.serialize()).where(data.getId() != -1 ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())).execute());
    }

    public void saveBatch(Collection<Data> dataBatch) {
        this.asyncPool.execute(() -> this.saveBatchSync(dataBatch));
    }

    public void saveBatchSync(Collection<Data> dataBatch) {
        this.databaseConnector.connectDSL(context -> {
            ArrayList queries = new ArrayList();
            for (Data data : dataBatch) {
                queries.add(context.insertInto(DSL.table(this.getTablePrefix() + data.getTableName())).set(data.serialize()).onConflict(data.getId() != -1 ? DSL.field("id") : DSL.field("uuid")).doUpdate().set(data.serialize()).where(data.getId() != -1 ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())));
            }
            context.batch(queries).execute();
        });
    }

    public void delete(Data data) {
        this.asyncPool.execute(() -> this.deleteSync(data));
    }

    public void deleteSync(Data data) {
        this.databaseConnector.connectDSL(context -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(data.getId() != -1 ? DSL.field("id").eq(data.getId()) : DSL.field("uuid").eq(data.getUniqueId().toString())).execute());
    }

    public void delete(Data data, String idField, Object idValue) {
        this.asyncPool.execute(() -> this.deleteSync(data, idField, idValue));
    }

    public void deleteSync(Data data, String idField, Object idValue) {
        this.databaseConnector.connectDSL(context -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(DSL.field(idField).eq(idValue)).execute());
    }

    public void delete(Data data, String uuidColumn) {
        this.asyncPool.execute(() -> this.databaseConnector.connectDSL(context -> context.delete(DSL.table(this.getTablePrefix() + data.getTableName())).where(data.getId() != -1 ? DSL.field("id").eq(data.getId()) : DSL.field(uuidColumn).eq(data.getUniqueId().toString())).execute()));
    }

    public <T extends Data> T load(int id, Class<?> clazz, String table) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.databaseConnector.connectDSL(context -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field("id").eq(id)).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> T load(UUID uuid, Class<?> clazz, String table) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.databaseConnector.connectDSL(context -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field("uuid").eq(uuid.toString())).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> T load(UUID uuid, Class<?> clazz, String table, String uuidColumn) {
        try {
            AtomicReference data = new AtomicReference();
            AtomicBoolean found = new AtomicBoolean(false);
            this.databaseConnector.connectDSL(context -> {
                try {
                    Data newData = (Data)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    data.set(newData.deserialize(((Record)Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(DSL.field(uuidColumn).eq(uuid.toString())).fetchOne())).intoMap()));
                    found.set(true);
                }
                catch (NullPointerException newData) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            if (found.get()) {
                return (T)((Data)data.get());
            }
            return null;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> List<T> loadBatch(Class<?> clazz, String table) {
        try {
            List dataList = Collections.synchronizedList(new ArrayList());
            this.databaseConnector.connectDSL(context -> {
                try {
                    for (Record record : Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).fetchArray())) {
                        Data data = (Data)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        dataList.add(data.deserialize(record.intoMap()));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return dataList;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public <T extends Data> List<T> loadBatch(Class<?> clazz, String table, Condition ... conditions) {
        try {
            List dataList = Collections.synchronizedList(new ArrayList());
            this.databaseConnector.connectDSL(context -> {
                try {
                    for (Record record : Objects.requireNonNull(context.select(new SelectFieldOrAsterisk[0]).from((TableLike<?>)DSL.table(this.getTablePrefix() + table)).where(conditions).fetchArray())) {
                        Data data = (Data)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        dataList.add(data.deserialize(record.intoMap()));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            return dataList;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void shutdown() {
        this.asyncPool.shutdown();
        try {
            if (!this.asyncPool.awaitTermination(30L, TimeUnit.SECONDS)) {
                this.plugin.getLogger().warning("Failed to shutdown the async DataManager pool in time. Forcing shutdown");
            }
        }
        catch (InterruptedException ex) {
            this.plugin.getLogger().warning("Error while shutting down the async DataManager pool: " + ex.getMessage());
        }
        this.asyncPool.shutdownNow();
        this.databaseConnector.closeConnection();
    }

    public List<Runnable> shutdownNow() {
        List<Runnable> tasksLeftInQueue = this.asyncPool.shutdownNow();
        this.databaseConnector.closeConnection();
        return tasksLeftInQueue;
    }

    public void shutdownTaskQueue() {
        this.asyncPool.shutdown();
    }

    public List<Runnable> forceShutdownTaskQueue() {
        return this.asyncPool.shutdownNow();
    }

    public boolean isTaskQueueTerminated() {
        return this.asyncPool.isTerminated();
    }

    public long getTaskQueueSize() {
        if (this.asyncPool instanceof ThreadPoolExecutor) {
            return ((ThreadPoolExecutor)this.asyncPool).getTaskCount();
        }
        return -1L;
    }

    public boolean waitForShutdown(long timeout, TimeUnit unit) throws InterruptedException {
        return this.asyncPool.awaitTermination(timeout, unit);
    }

    public String getSyntax(String string, DatabaseType type) {
        if (this.type == type) {
            return string;
        }
        return "";
    }
}

