/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.configuration;

import java.util.List;

public class ConfigFormattingRules {
    int spacesBetweenMainCategories;
    int spacesBetweenValues;
    CommentStyle rootCommentStyle = CommentStyle.BLOCKSPACED;
    CommentStyle mainCategoryCommentStyle = CommentStyle.SPACED;

    public static CommentStyle parseStyle(List<String> lines) {
        boolean hasBorders;
        if (lines == null || lines.size() <= 2) {
            return CommentStyle.SIMPLE;
        }
        if (lines.get(0).trim().equals("#") && lines.get(lines.size() - 1).trim().equals("#")) {
            return CommentStyle.SPACED;
        }
        boolean bl = hasBorders = lines.get(0).trim().matches("^##+$") && lines.get(lines.size() - 1).trim().matches("^##+$");
        if (!hasBorders) {
            return CommentStyle.SIMPLE;
        }
        if (lines.size() > 4 && lines.get(1).trim().matches(("^#" + CommentStyle.BLOCKSPACED.spacePrefixTop + CommentStyle.BLOCKSPACED.spaceCharTop + "+" + CommentStyle.BLOCKSPACED.spaceSuffixTop + "#$").replace("|", "\\|")) && lines.get(1).trim().matches(("^#" + CommentStyle.BLOCKSPACED.spacePrefixTop + CommentStyle.BLOCKSPACED.spaceCharTop + "+" + CommentStyle.BLOCKSPACED.spaceSuffixTop + "#$").replace("|", "\\|"))) {
            return CommentStyle.BLOCKSPACED;
        }
        return CommentStyle.BLOCKED;
    }

    public static enum CommentStyle {
        SIMPLE(false, false, " ", ""),
        SPACED(false, true, " ", ""),
        BLOCKED(true, false, " ", " "),
        BLOCKSPACED(true, true, "|\u00af", '\u00af', "\u00af|", "| ", " |", "|_", '_', "_|");

        final boolean drawBorder;
        final boolean drawSpace;
        final String commentPrefix;
        final String spacePrefixTop;
        final String spacePrefixBottom;
        final String commentSuffix;
        final String spaceSuffixTop;
        final String spaceSuffixBottom;
        final char spaceCharTop;
        final char spaceCharBottom;

        private CommentStyle(boolean drawBorder, boolean drawSpace, String spacePrefixTop, char spaceCharTop, String spaceSuffixTop, String commentPrefix, String commentSuffix, String spacePrefixBottom, char spaceCharBottom, String spaceSuffixBottom) {
            this.drawBorder = drawBorder;
            this.drawSpace = drawSpace;
            this.commentPrefix = commentPrefix;
            this.spacePrefixTop = spacePrefixTop;
            this.spacePrefixBottom = spacePrefixBottom;
            this.commentSuffix = commentSuffix;
            this.spaceSuffixTop = spaceSuffixTop;
            this.spaceSuffixBottom = spaceSuffixBottom;
            this.spaceCharTop = spaceCharTop;
            this.spaceCharBottom = spaceCharBottom;
        }

        private CommentStyle(boolean drawBorder, boolean drawSpace, String commentPrefix, String commentSuffix) {
            this.drawBorder = drawBorder;
            this.drawSpace = drawSpace;
            this.commentPrefix = commentPrefix;
            this.commentSuffix = commentSuffix;
            this.spacePrefixBottom = "";
            this.spacePrefixTop = "";
            this.spaceCharBottom = (char)32;
            this.spaceCharTop = (char)32;
            this.spaceSuffixBottom = "";
            this.spaceSuffixTop = "";
        }
    }
}

