/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.compatibility;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;

public enum LegacyMaterialBlockType {
    OAK_LEAVES("LEAVES", 8, true),
    SPRUCE_LEAVES("LEAVES", 9, true),
    BIRCH_LEAVES("LEAVES", 10, true),
    JUNGLE_LEAVES("LEAVES", 11, true),
    ACACIA_LEAVES("LEAVES_2", 8, true),
    DARK_OAK_LEAVES("LEAVES_2", 9, true),
    ACACIA_DOOR("ACACIA_DOOR", true),
    BED("BED_BLOCK", true),
    BIRCH_DOOR("BIRCH_DOOR", true),
    FURNACE("FURNACE", "BURNING_FURNACE"),
    CAKE("CAKE_BLOCK"),
    CARROTS("CARROT"),
    CAULDRON("CAULDRON_BLOCK"),
    COMPARATOR("REDSTONE_COMPARATOR_OFF", "REDSTONE_COMPARATOR_ON"),
    DARK_OAK_DOOR("DARK_OAK_DOOR", true),
    DAYLIGHT_DETECTOR("DAYLIGHT_DETECTOR", "DAYLIGHT_DETECTOR_INVERTED"),
    FLOWER_POT("FLOWER_POT"),
    IRON_DOOR("IRON_DOOR_BLOCK", true),
    JUNGLE_DOOR("JUNGLE_DOOR", true),
    LAVA("STATIONARY_LAVA"),
    NETHER_WART("NETHER_WARTS"),
    POTATOES("POTATO"),
    REDSTONE_LAMP("REDSTONE_LAMP_OFF", "REDSTONE_LAMP_ON"),
    REDSTONE_ORE("REDSTONE_ORE", "GLOWING_REDSTONE_ORE"),
    REDSTONE_TORCH("REDSTONE_TORCH_ON", "REDSTONE_TORCH_OFF"),
    SPRUCE_DOOR("SPRUCE_DOOR"),
    SUGAR_CANE("SUGAR_CANE_BLOCK"),
    WATER("STATIONARY_WATER"),
    WHEAT("CROPS");

    final String blockMaterialName;
    final byte blockData;
    final String alternateBlockMaterialName;
    final Material blockMaterial;
    final Material alternateBlockMaterial;
    final boolean requiresData;
    static final Map<String, LegacyMaterialBlockType> lookupTable;
    static final Map<String, LegacyMaterialBlockType> reverseLookupTable;

    private LegacyMaterialBlockType(String blockMaterial) {
        this(blockMaterial, -1, null, false);
    }

    private LegacyMaterialBlockType(String blockMaterial, boolean requiresData) {
        this(blockMaterial, -1, null, requiresData);
    }

    private LegacyMaterialBlockType(String blockMaterial, byte data, boolean requiresData) {
        this(blockMaterial, data, null, requiresData);
    }

    private LegacyMaterialBlockType(String blockMaterial, String alternateMaterial) {
        this(blockMaterial, -1, alternateMaterial, false);
    }

    private LegacyMaterialBlockType(String blockMaterial, byte data, String alternateMaterial, boolean requiresData) {
        this.blockMaterialName = blockMaterial;
        this.alternateBlockMaterialName = alternateMaterial;
        this.requiresData = requiresData;
        this.blockMaterial = Material.getMaterial((String)this.blockMaterialName);
        this.alternateBlockMaterial = Material.getMaterial((String)this.alternateBlockMaterialName);
        this.blockData = data;
    }

    public String getBlockMaterialName() {
        return this.blockMaterialName;
    }

    public String getAlternateMaterialName() {
        return this.alternateBlockMaterialName;
    }

    public Material getBlockMaterial() {
        return this.blockMaterial;
    }

    public Material getAlternateBlockMaterial() {
        return this.alternateBlockMaterial;
    }

    public boolean requiresData() {
        return this.requiresData;
    }

    public static LegacyMaterialBlockType getMaterial(String lookup) {
        return lookupTable.get(lookup);
    }

    public static LegacyMaterialBlockType getFromLegacy(String lookup, byte data) {
        return reverseLookupTable.get(lookup + ":" + data);
    }

    public static LegacyMaterialBlockType getFromLegacy(String lookup) {
        return LegacyMaterialBlockType.getFromLegacy(lookup, (byte)-1);
    }

    static {
        lookupTable = new HashMap<String, LegacyMaterialBlockType>();
        reverseLookupTable = new HashMap<String, LegacyMaterialBlockType>();
        for (LegacyMaterialBlockType t : LegacyMaterialBlockType.values()) {
            lookupTable.put(t.name(), t);
            reverseLookupTable.put(t.blockMaterialName + ":" + t.blockData, t);
            if (t.alternateBlockMaterialName == null) continue;
            reverseLookupTable.put(t.alternateBlockMaterialName, t);
        }
    }
}

