/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.core.compatibility;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.EntityType;

public class EntityNamespace {
    static final HashMap<String, EntityType> validTypes = new HashMap();
    static final HashMap<String, String> legacyToModernTypes = new HashMap<String, String>(){
        {
            this.put("xporb", "experience_orb");
            this.put("xp_orb", "experience_orb");
            this.put("leashknot", "leash_knot");
            this.put("smallfireball", "small_fireball");
            this.put("thrownenderpearl", "ender_pearl");
            this.put("eyeofendersignal", "eye_of_ender");
            this.put("eye_of_ender_signal", "eye_of_ender");
            this.put("thrownexpbottle", "experience_bottle");
            this.put("xp_bottle", "experience_bottle");
            this.put("itemframe", "item_frame");
            this.put("witherskull", "wither_skull");
            this.put("primedtnt", "tnt");
            this.put("fallingsand", "falling_block");
            this.put("fireworksrocketentity", "firework_rocket");
            this.put("fireworks_rocket", "firework_rocket");
            this.put("spectralarrow", "spectral_arrow");
            this.put("tippedarrow", "arrow");
            this.put("shulkerbullet", "shulker_bullet");
            this.put("dragonfireball", "dragon_fireball");
            this.put("armorstand", "armor_stand");
            this.put("minecartcommandblock", "command_block_minecart");
            this.put("commandblock_minecart", "command_block_minecart");
            this.put("minecartrideable", "minecart");
            this.put("minecartchest", "chest_minecart");
            this.put("minecartfurnace", "furnace_minecart");
            this.put("minecarttnt", "tnt_minecart");
            this.put("minecarthopper", "hopper_minecart");
            this.put("minecartmobspawner", "spawner_minecart");
            this.put("pigzombie", "zombie_pigman");
            this.put("cavespider", "cave_spider");
            this.put("lavaslime", "magma_cube");
            this.put("enderdragon", "ender_dragon");
            this.put("witherboss", "wither");
            this.put("mushroomcow", "mooshroom");
            this.put("snowman", "snow_golem");
            this.put("ozelot", "ocelot");
            this.put("villagergolem", "iron_golem");
            this.put("villager_golem", "iron_golem");
            this.put("entityhorse", "horse");
            this.put("endercrystal", "end_crystal");
            this.put("ender_crystal", "end_crystal");
        }
    };

    public static EntityType minecraftToBukkit(String entity) {
        if (entity == null) {
            return null;
        }
        EntityType type = EntityType.fromName((String)entity);
        if (type == null && (type = EntityType.fromName((String)legacyToModernTypes.get(entity))) == null && legacyToModernTypes.containsValue(entity)) {
            for (Map.Entry<String, String> e : legacyToModernTypes.entrySet()) {
                if (!e.getValue().equals(entity) || (type = EntityType.fromName((String)legacyToModernTypes.get(e.getKey()))) == null) continue;
                return type;
            }
        }
        return type;
    }

    static {
        for (EntityType t : EntityType.values()) {
            if (t.getName() == null) continue;
            validTypes.put(t.getName().toLowerCase(), t);
        }
    }
}

