/*
 * Decompiled with CFR 0.152.
 */
package com.craftaro.ultimatestacker.api.events.entity;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.entity.Item;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StackedItemSpawnEvent
extends Event
implements Cancellable {
    private static final HandlerList handlers = new HandlerList();
    private Item item;
    private ItemStack itemStack;
    private long amount;
    private boolean cancelled = false;
    private Map<String, Object> extraData = new HashMap<String, Object>();

    public StackedItemSpawnEvent(@Nullable Item item, @NotNull ItemStack itemStack, long amount) {
        this.item = item;
        this.itemStack = itemStack;
        this.amount = amount;
    }

    public StackedItemSpawnEvent(@Nullable Item item, @NotNull ItemStack itemStack, long amount, @NotNull Map<String, Object> extraData) {
        this.item = item;
        this.itemStack = itemStack;
        this.amount = amount;
        this.extraData = extraData;
    }

    @NotNull
    public Map<String, Object> getExtraData() {
        return this.extraData;
    }

    public void addExtraData(String key, Object value) {
        this.extraData.put(key, value);
    }

    @Nullable
    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
    }

    @NotNull
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        if (itemStack == null) {
            throw new IllegalArgumentException("ItemStack cannot be null");
        }
        this.itemStack = itemStack;
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public void setCancelled(boolean b) {
        this.cancelled = true;
    }
}

