/*
 * Decompiled with CFR 0.152.
 */
package net.shatteredlands.shatt.backup;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipLibrary {
    private static String BACKUP_DIRECTORY = mcMMO.getMainDirectory() + "backup" + File.separator;
    private static File BACKUP_DIR = new File(BACKUP_DIRECTORY);
    private static File FLAT_FILE_DIRECTORY = new File(mcMMO.getFlatFileDirectory());
    private static File MOD_FILE_DIRECTORY = new File(mcMMO.getModDirectory());
    private static File CONFIG_FILE = new File(mcMMO.getMainDirectory() + "config.yml");
    private static File EXPERIENCE_FILE = new File(mcMMO.getMainDirectory() + "experience.yml");
    private static File TREASURE_FILE = new File(mcMMO.getMainDirectory() + "treasures.yml");
    private static File ADVANCED_FILE = new File(mcMMO.getMainDirectory() + "advanced.yml");
    private static File REPAIR_FILE = new File(mcMMO.getMainDirectory() + "repair.vanilla.yml");

    public static void mcMMOBackup() {
        if (Config.getInstance().getUseMySQL()) {
            mcMMO.p.debug("This server is running in SQL Mode.");
            mcMMO.p.debug("Only config files will be backed up.");
        }
        try {
            if (BACKUP_DIR.mkdir()) {
                mcMMO.p.debug("Created Backup Directory.");
            }
        }
        catch (Exception exception) {
            mcMMO.p.getLogger().severe(exception.toString());
        }
        Date date = new Date();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH-mm-ss");
        File file = new File(BACKUP_DIRECTORY + File.separator + simpleDateFormat.format(date) + ".zip");
        ArrayList<File> arrayList = new ArrayList<File>();
        arrayList.add(FLAT_FILE_DIRECTORY);
        arrayList.add(CONFIG_FILE);
        arrayList.add(EXPERIENCE_FILE);
        arrayList.add(TREASURE_FILE);
        arrayList.add(ADVANCED_FILE);
        arrayList.add(REPAIR_FILE);
        if (MOD_FILE_DIRECTORY.exists()) {
            arrayList.add(MOD_FILE_DIRECTORY);
        }
        mcMMO.p.debug("Backing up your mcMMO Configuration... ");
        ZipLibrary.packZip(file, arrayList);
    }

    private static void packZip(File file, List<File> list) {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
        zipOutputStream.setLevel(-1);
        for (File file2 : list) {
            if (file2.isDirectory()) {
                ZipLibrary.zipDir(zipOutputStream, "", file2);
                continue;
            }
            ZipLibrary.zipFile(zipOutputStream, "", file2);
        }
        zipOutputStream.flush();
        zipOutputStream.close();
        mcMMO.p.debug("Backup Completed.");
    }

    private static String buildPath(String string, String string2) {
        if (string == null || string.isEmpty()) {
            return string2;
        }
        return string + File.separator + string2;
    }

    private static void zipDir(ZipOutputStream zipOutputStream, String string, File file) {
        if (!file.canRead()) {
            mcMMO.p.getLogger().severe("Cannot read " + file.getCanonicalPath() + " (Maybe because of permissions?)");
            return;
        }
        File[] fileArray = file.listFiles();
        string = ZipLibrary.buildPath(string, file.getName());
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                ZipLibrary.zipDir(zipOutputStream, string, file2);
                continue;
            }
            ZipLibrary.zipFile(zipOutputStream, string, file2);
        }
    }

    private static void zipFile(ZipOutputStream zipOutputStream, String string, File file) {
        int n;
        if (!file.canRead()) {
            mcMMO.p.getLogger().severe("Cannot read " + file.getCanonicalPath() + "(File Permissions?)");
            return;
        }
        zipOutputStream.putNextEntry(new ZipEntry(ZipLibrary.buildPath(string, file.getName())));
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[4092];
        while ((n = fileInputStream.read(byArray)) != -1) {
            zipOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        zipOutputStream.closeEntry();
    }
}

