/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.worldguard;

import com.gmail.nossr50.worldguard.WorldGuardFlags;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldedit.bukkit.BukkitPlayer;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class WorldGuardManager {
    private static WorldGuardManager instance;
    private WorldGuardPlugin worldGuardPluginRef;

    public static WorldGuardManager getInstance() {
        if (instance == null) {
            instance = new WorldGuardManager();
        }
        return instance;
    }

    public boolean hasMainFlag(Player player) {
        if (player == null) {
            return false;
        }
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt((Player)player);
        Location location = bukkitPlayer.getLocation();
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return regionQuery.testState(location, WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{WorldGuardFlags.MCMMO_ENABLE_WG_FLAG});
    }

    public boolean hasXPFlag(Player player) {
        if (player == null) {
            return false;
        }
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt((Player)player);
        Location location = bukkitPlayer.getLocation();
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return regionQuery.testState(location, WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{WorldGuardFlags.MCMMO_XP_WG_FLAG});
    }

    public boolean hasHardcoreFlag(Player player) {
        if (player == null) {
            return false;
        }
        BukkitPlayer bukkitPlayer = BukkitAdapter.adapt((Player)player);
        Location location = bukkitPlayer.getLocation();
        RegionQuery regionQuery = WorldGuard.getInstance().getPlatform().getRegionContainer().createQuery();
        return regionQuery.testState(location, WorldGuardPlugin.inst().wrapPlayer(player), new StateFlag[]{WorldGuardFlags.MCMMO_HARDCORE_WG_FLAG});
    }

    private WorldGuardPlugin getWorldGuard() {
        Plugin plugin = Bukkit.getServer().getPluginManager().getPlugin("WorldGuard");
        if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
            return null;
        }
        this.worldGuardPluginRef = (WorldGuardPlugin)plugin;
        return this.worldGuardPluginRef;
    }

    public void registerFlags() {
        FlagRegistry flagRegistry = WorldGuard.getInstance().getFlagRegistry();
        try {
            flagRegistry.register((Flag)WorldGuardFlags.MCMMO_ENABLE_WG_FLAG);
            flagRegistry.register((Flag)WorldGuardFlags.MCMMO_XP_WG_FLAG);
            flagRegistry.register((Flag)WorldGuardFlags.MCMMO_HARDCORE_WG_FLAG);
            System.out.println("mcMMO has registered WG flags successfully!");
        }
        catch (FlagConflictException flagConflictException) {
            flagConflictException.printStackTrace();
            System.out.println("mcMMO has failed to register WG flags!");
        }
    }
}

