/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.uuid;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;

public class UUIDFetcher
implements Callable<Map<String, UUID>> {
    private static final int PROFILES_PER_REQUEST = 50;
    private static final long RATE_LIMIT = 100L;
    private static final String PROFILE_URL = "https://api.mojang.com/profiles/minecraft";
    private final List<String> names;
    private final boolean rateLimiting;

    public UUIDFetcher(List<String> list, boolean bl) {
        this.names = ImmutableList.copyOf(list);
        this.rateLimiting = bl;
    }

    public UUIDFetcher(List<String> list) {
        this(list, true);
    }

    @Override
    public Map<String, UUID> call() {
        HashMap<String, UUID> hashMap = new HashMap<String, UUID>();
        int n = (int)Math.ceil(this.names.size() / 50);
        for (int i = 0; i < n; ++i) {
            JsonObject[] jsonObjectArray;
            String string2;
            HttpURLConnection httpURLConnection = UUIDFetcher.createConnection();
            List<String> list = this.names.subList(i * 50, Math.min((i + 1) * 50, this.names.size()));
            JsonArray jsonArray = new JsonArray();
            for (String string2 : list) {
                jsonObjectArray = new JsonPrimitive(string2);
                jsonArray.add((JsonElement)jsonObjectArray);
            }
            Gson gson = new Gson();
            string2 = jsonArray.toString();
            UUIDFetcher.writeBody(httpURLConnection, string2);
            for (JsonObject jsonObject : jsonObjectArray = (JsonObject[])gson.fromJson((Reader)new InputStreamReader(httpURLConnection.getInputStream()), JsonObject[].class)) {
                String string3 = jsonObject.get("id").getAsString();
                String string4 = jsonObject.get("name").getAsString();
                UUID uUID = UUIDFetcher.getUUID(string3);
                hashMap.put(string4, uUID);
            }
            if (!this.rateLimiting || i == n - 1) continue;
            Thread.sleep(100L);
        }
        return hashMap;
    }

    private static void writeBody(HttpURLConnection httpURLConnection, String string) {
        OutputStream outputStream = httpURLConnection.getOutputStream();
        outputStream.write(string.getBytes());
        outputStream.flush();
        outputStream.close();
    }

    private static HttpURLConnection createConnection() {
        URL uRL = new URL(PROFILE_URL);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setDoOutput(true);
        return httpURLConnection;
    }

    private static UUID getUUID(String string) {
        return UUID.fromString(string.substring(0, 8) + "-" + string.substring(8, 12) + "-" + string.substring(12, 16) + "-" + string.substring(16, 20) + "-" + string.substring(20, 32));
    }

    public static byte[] toBytes(UUID uUID) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[16]);
        byteBuffer.putLong(uUID.getMostSignificantBits());
        byteBuffer.putLong(uUID.getLeastSignificantBits());
        return byteBuffer.array();
    }

    public static UUID fromBytes(byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("Illegal byte array length: " + byArray.length);
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        long l = byteBuffer.getLong();
        long l2 = byteBuffer.getLong();
        return new UUID(l, l2);
    }

    public static UUID getUUIDOf(String string) {
        return (UUID)new UUIDFetcher(Arrays.asList(string)).call().get(string);
    }
}

