/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.upgrade;

import com.gmail.nossr50.config.ConfigLoader;
import com.gmail.nossr50.datatypes.database.UpgradeType;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;

public class UpgradeManager
extends ConfigLoader {
    private final Set<UpgradeType> setNeededUpgrades = EnumSet.allOf(UpgradeType.class);

    public UpgradeManager() {
        super("upgrades.yml");
        this.loadKeys();
    }

    public boolean shouldUpgrade(UpgradeType upgradeType) {
        return this.setNeededUpgrades.contains((Object)upgradeType);
    }

    public void setUpgradeCompleted(UpgradeType upgradeType) {
        if (!this.setNeededUpgrades.remove((Object)upgradeType)) {
            return;
        }
        plugin.debug("Saving upgrade status for type " + upgradeType.toString() + "...");
        this.config.set("Upgrades_Finished." + upgradeType.toString(), (Object)true);
        try {
            this.config.save(this.getFile());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    protected void loadKeys() {
        for (UpgradeType upgradeType : UpgradeType.values()) {
            if (!this.config.getBoolean("Upgrades_Finished." + upgradeType.toString())) continue;
            this.setNeededUpgrades.remove((Object)upgradeType);
        }
        plugin.debug("Needed upgrades: " + Arrays.toString((Object[])this.setNeededUpgrades.toArray(new UpgradeType[this.setNeededUpgrades.size()])));
    }
}

