/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.sounds;

import com.gmail.nossr50.config.SoundConfig;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.sounds.SoundType;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.SoundCategory;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class SoundManager {
    public static void sendSound(Player player, Location location, SoundType soundType) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), SoundCategory.MASTER, SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void sendCategorizedSound(Player player, Location location, SoundType soundType, SoundCategory soundCategory) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    public static void sendCategorizedSound(Player player, Location location, SoundType soundType, SoundCategory soundCategory, float f) {
        float f2 = Math.min(2.0f, SoundManager.getPitch(soundType) + f);
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            player.playSound(location, SoundManager.getSound(soundType), soundCategory, SoundManager.getVolume(soundType), f2);
        }
    }

    public static void worldSendSound(World world, Location location, SoundType soundType) {
        if (SoundConfig.getInstance().getIsEnabled(soundType)) {
            world.playSound(location, SoundManager.getSound(soundType), SoundManager.getVolume(soundType), SoundManager.getPitch(soundType));
        }
    }

    private static float getVolume(SoundType soundType) {
        return SoundConfig.getInstance().getVolume(soundType) * SoundConfig.getInstance().getMasterVolume();
    }

    private static float getPitch(SoundType soundType) {
        if (soundType == SoundType.FIZZ) {
            return SoundManager.getFizzPitch();
        }
        if (soundType == SoundType.POP) {
            return SoundManager.getPopPitch();
        }
        return SoundConfig.getInstance().getPitch(soundType);
    }

    private static Sound getSound(SoundType soundType) {
        switch (soundType) {
            case ANVIL: {
                return Sound.BLOCK_ANVIL_PLACE;
            }
            case ITEM_BREAK: {
                return Sound.ENTITY_ITEM_BREAK;
            }
            case POP: {
                return Sound.ENTITY_ITEM_PICKUP;
            }
            case CHIMAERA_WING: {
                return Sound.ENTITY_BAT_TAKEOFF;
            }
            case LEVEL_UP: {
                return Sound.ENTITY_PLAYER_LEVELUP;
            }
            case FIZZ: {
                return Sound.BLOCK_FIRE_EXTINGUISH;
            }
            case TOOL_READY: {
                return Sound.ITEM_ARMOR_EQUIP_GOLD;
            }
            case ROLL_ACTIVATED: {
                return Sound.ENTITY_LLAMA_SWAG;
            }
            case SKILL_UNLOCKED: {
                return Sound.UI_TOAST_CHALLENGE_COMPLETE;
            }
            case ABILITY_ACTIVATED_BERSERK: {
                return Sound.BLOCK_CONDUIT_AMBIENT;
            }
            case ABILITY_ACTIVATED_GENERIC: {
                return Sound.ITEM_TRIDENT_RIPTIDE_3;
            }
            case DEFLECT_ARROWS: {
                return Sound.ENTITY_ENDER_EYE_DEATH;
            }
            case TIRED: {
                return Sound.BLOCK_CONDUIT_AMBIENT;
            }
            case BLEED: {
                return Sound.ENTITY_ENDER_EYE_DEATH;
            }
        }
        return null;
    }

    public static float getFizzPitch() {
        return 2.6f + (Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.8f;
    }

    public static float getPopPitch() {
        return ((Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.7f + 1.0f) * 2.0f;
    }

    public static float getKrakenPitch() {
        return (Misc.getRandom().nextFloat() - Misc.getRandom().nextFloat()) * 0.2f + 1.0f;
    }
}

