/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.HiddenConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.experience.XPGainSource;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.PerksUtils;
import com.gmail.nossr50.util.skills.RankUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class SkillUtils {
    public static void applyXpGain(McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason) {
        mcMMOPlayer.beginXpGain(primarySkillType, f, xPGainReason, XPGainSource.SELF);
    }

    public static void applyXpGain(McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, float f, XPGainReason xPGainReason, XPGainSource xPGainSource) {
        mcMMOPlayer.beginXpGain(primarySkillType, f, xPGainReason, xPGainSource);
    }

    public static String[] calculateLengthDisplayValues(Player player, float f, PrimarySkillType primarySkillType) {
        int n = primarySkillType.getAbility().getMaxLength();
        int n2 = AdvancedConfig.getInstance().getAbilityLength();
        int n3 = AdvancedConfig.getInstance().getAbilityLengthCap();
        int n4 = n3 > 0 ? (int)Math.min((float)n3, 2.0f + f / (float)n2) : 2 + (int)(f / (float)n2);
        int n5 = PerksUtils.handleActivationPerks(player, n4, n);
        if (n != 0) {
            n4 = Math.min(n4, n);
        }
        return new String[]{String.valueOf(n4), String.valueOf(n5)};
    }

    public static int handleFoodSkills(Player player, int n, SubSkillType subSkillType) {
        int n2 = RankUtils.getRank(player, subSkillType);
        int n3 = player.getFoodLevel();
        int n4 = n - n3;
        return n3 + (n4 += n2);
    }

    public static int calculateTimeLeft(long l, int n, Player player) {
        return (int)((l + (long)(PerksUtils.handleCooldownPerks(player, n) * 1000) - System.currentTimeMillis()) / 1000L);
    }

    public static boolean cooldownExpired(long l, int n) {
        return System.currentTimeMillis() >= (l + (long)n) * 1000L;
    }

    public static boolean isSkill(String string) {
        return Config.getInstance().getLocale().equalsIgnoreCase("en_US") ? PrimarySkillType.getSkill(string) != null : SkillUtils.isLocalizedSkill(string);
    }

    public static void sendSkillMessage(Player player, NotificationType notificationType, String string) {
        Location location = player.getLocation();
        for (Player player2 : player.getWorld().getPlayers()) {
            if (player2 == player || !Misc.isNear(location, player2.getLocation(), 10.0)) continue;
            NotificationManager.sendNearbyPlayersInformation(player2, notificationType, string, player.getName());
        }
    }

    public static void handleAbilitySpeedIncrease(Player player) {
        if (HiddenConfig.getInstance().useEnchantmentBuffs()) {
            ItemStack itemStack = player.getInventory().getItemInMainHand();
            if (itemStack == null || itemStack.getType() == Material.AIR) {
                return;
            }
            int n = itemStack.getEnchantmentLevel(Enchantment.DIG_SPEED);
            ItemMeta itemMeta = itemStack.getItemMeta();
            List<String> list = new ArrayList<String>();
            if (itemMeta.hasLore()) {
                list = itemMeta.getLore();
            }
            list.add("mcMMO Ability Tool");
            itemMeta.addEnchant(Enchantment.DIG_SPEED, n + AdvancedConfig.getInstance().getEnchantBuff(), true);
            itemMeta.setLore(list);
            itemStack.setItemMeta(itemMeta);
        } else {
            Object object;
            Object object2;
            int n = 0;
            int n2 = 0;
            if (player.hasPotionEffect(PotionEffectType.FAST_DIGGING)) {
                object2 = player.getActivePotionEffects().iterator();
                while (object2.hasNext()) {
                    object = (PotionEffect)object2.next();
                    if (object.getType() != PotionEffectType.FAST_DIGGING) continue;
                    n = object.getDuration();
                    n2 = object.getAmplifier();
                    break;
                }
            }
            if ((object2 = UserManager.getPlayer(player)) == null) {
                return;
            }
            object = ((McMMOPlayer)object2).getAbilityMode(SuperAbilityType.SUPER_BREAKER) ? PrimarySkillType.MINING : PrimarySkillType.EXCAVATION;
            int n3 = AdvancedConfig.getInstance().getAbilityLength();
            int n4 = AdvancedConfig.getInstance().getAbilityLengthCap();
            int n5 = n4 > 0 ? PerksUtils.handleActivationPerks(player, Math.min(n4, 2 + ((McMMOPlayer)object2).getSkillLevel((PrimarySkillType)((Object)object)) / n3), ((PrimarySkillType)((Object)object)).getAbility().getMaxLength()) * 20 : PerksUtils.handleActivationPerks(player, 2 + ((McMMOPlayer)object2).getSkillLevel((PrimarySkillType)((Object)object)) / n3, ((PrimarySkillType)((Object)object)).getAbility().getMaxLength()) * 20;
            PotionEffect potionEffect = new PotionEffect(PotionEffectType.FAST_DIGGING, n + n5, n2 + 10);
            player.addPotionEffect(potionEffect, true);
        }
    }

    public static void handleAbilitySpeedDecrease(Player player) {
        if (!HiddenConfig.getInstance().useEnchantmentBuffs()) {
            return;
        }
        for (ItemStack itemStack : player.getInventory().getContents()) {
            SkillUtils.removeAbilityBuff(itemStack);
        }
    }

    public static void removeAbilityBuff(ItemStack itemStack) {
        List list;
        if (itemStack == null || itemStack.getType() == Material.AIR || !ItemUtils.isPickaxe(itemStack) && !ItemUtils.isShovel(itemStack) || !itemStack.containsEnchantment(Enchantment.DIG_SPEED)) {
            return;
        }
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta.hasLore() && (list = itemMeta.getLore()).remove("mcMMO Ability Tool")) {
            int n = itemStack.getEnchantmentLevel(Enchantment.DIG_SPEED);
            if (n <= AdvancedConfig.getInstance().getEnchantBuff()) {
                itemMeta.removeEnchant(Enchantment.DIG_SPEED);
            } else {
                itemMeta.addEnchant(Enchantment.DIG_SPEED, n - AdvancedConfig.getInstance().getEnchantBuff(), true);
            }
            itemMeta.setLore(list);
            itemStack.setItemMeta(itemMeta);
        }
    }

    public static void handleDurabilityChange(ItemStack itemStack, int n) {
        SkillUtils.handleDurabilityChange(itemStack, n, 1.0);
    }

    public static void handleDurabilityChange(ItemStack itemStack, double d, double d2) {
        if (itemStack.getItemMeta() != null && itemStack.getItemMeta().isUnbreakable()) {
            return;
        }
        Material material = itemStack.getType();
        short s = mcMMO.getRepairableManager().isRepairable(material) ? mcMMO.getRepairableManager().getRepairable(material).getMaximumDurability() : material.getMaxDurability();
        d = (int)Math.min(d / (double)(itemStack.getEnchantmentLevel(Enchantment.DURABILITY) + 1), (double)s * d2);
        itemStack.setDurability((short)Math.min((double)itemStack.getDurability() + d, (double)s));
    }

    private static boolean isLocalizedSkill(String string) {
        for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
            if (!string.equalsIgnoreCase(LocaleLoader.getString(StringUtils.getCapitalized(primarySkillType.toString()) + ".SkillName"))) continue;
            return true;
        }
        return false;
    }

    protected static Material getRepairAndSalvageItem(ItemStack itemStack) {
        if (ItemUtils.isDiamondTool(itemStack) || ItemUtils.isDiamondArmor(itemStack)) {
            return Material.DIAMOND;
        }
        if (ItemUtils.isGoldTool(itemStack) || ItemUtils.isGoldArmor(itemStack)) {
            return Material.GOLD_INGOT;
        }
        if (ItemUtils.isIronTool(itemStack) || ItemUtils.isIronArmor(itemStack)) {
            return Material.IRON_INGOT;
        }
        if (ItemUtils.isStoneTool(itemStack)) {
            return Material.COBBLESTONE;
        }
        if (ItemUtils.isWoodTool(itemStack)) {
            return Material.OAK_WOOD;
        }
        if (ItemUtils.isLeatherArmor(itemStack)) {
            return Material.LEATHER;
        }
        if (ItemUtils.isStringTool(itemStack)) {
            return Material.STRING;
        }
        return null;
    }

    public static int getRepairAndSalvageQuantities(ItemStack itemStack) {
        return SkillUtils.getRepairAndSalvageQuantities(itemStack.getType(), SkillUtils.getRepairAndSalvageItem(itemStack));
    }

    public static int getRepairAndSalvageQuantities(Material material, Material material2) {
        int n = 0;
        Iterator iterator = Bukkit.getServer().recipeIterator();
        while (iterator.hasNext()) {
            Recipe recipe = (Recipe)iterator.next();
            if (recipe.getResult().getType() != material) continue;
            if (recipe instanceof ShapelessRecipe) {
                for (ItemStack itemStack : ((ShapelessRecipe)recipe).getIngredientList()) {
                    if (itemStack == null || material2 != null && itemStack.getType() != material2 || itemStack.getType() != material2) continue;
                    n += itemStack.getAmount();
                }
                continue;
            }
            if (!(recipe instanceof ShapedRecipe)) continue;
            for (ItemStack itemStack : ((ShapedRecipe)recipe).getIngredientMap().values()) {
                if (itemStack == null || material2 != null && itemStack.getType() != material2 || itemStack.getType() != material2) continue;
                n += itemStack.getAmount();
            }
        }
        return n;
    }
}

