/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.RankConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.listeners.InteractionManager;
import com.gmail.nossr50.runnables.skills.SkillUnlockNotificationTask;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import java.util.HashMap;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class RankUtils {
    private static HashMap<String, HashMap<Integer, Integer>> subSkillRanks;
    private static int count;

    public static void executeSkillUnlockNotifications(Plugin plugin, McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, int n) {
        for (SubSkillType subSkillType : primarySkillType.getSkillAbilities()) {
            int n2 = RankUtils.getRank(mcMMOPlayer.getPlayer(), subSkillType);
            HashMap<Integer, Integer> hashMap = subSkillRanks.get(subSkillType.toString());
            if (hashMap == null || hashMap.get(n2) == null || !Permissions.isSubSkillEnabled((Permissible)mcMMOPlayer.getPlayer(), subSkillType) || n != hashMap.get(n2)) continue;
            SkillUnlockNotificationTask skillUnlockNotificationTask = new SkillUnlockNotificationTask(mcMMOPlayer, subSkillType, n);
            skillUnlockNotificationTask.runTaskLater(plugin, count * 100);
            ++count;
        }
    }

    public static void resetUnlockDelayTimer() {
        count = 0;
    }

    private static void addRanks(AbstractSubSkill abstractSubSkill) {
        for (int i = 0; i < abstractSubSkill.getNumRanks(); ++i) {
            RankUtils.addRank(abstractSubSkill, abstractSubSkill.getNumRanks() - i);
        }
    }

    private static void addRanks(SubSkillType subSkillType) {
        for (int i = 0; i < subSkillType.getNumRanks(); ++i) {
            RankUtils.addRank(subSkillType, subSkillType.getNumRanks() - i);
        }
    }

    public static void populateRanks() {
        for (SubSkillType subSkillType : SubSkillType.values()) {
            RankUtils.addRanks(subSkillType);
        }
        for (AbstractSubSkill abstractSubSkill : InteractionManager.getSubSkillList()) {
            RankUtils.addRanks(abstractSubSkill);
        }
    }

    public static boolean hasUnlockedSubskill(Player player, SubSkillType subSkillType) {
        int n = RankUtils.getRank(player, subSkillType);
        return n == -1 || n >= 1;
    }

    public static boolean hasUnlockedSubskill(Player player, AbstractSubSkill abstractSubSkill) {
        int n = RankUtils.getRank(player, abstractSubSkill);
        return n == -1 || n >= 1;
    }

    public static boolean hasReachedRank(int n, Player player, SubSkillType subSkillType) {
        return RankUtils.getRank(player, subSkillType) >= n;
    }

    public static boolean hasReachedRank(int n, Player player, AbstractSubSkill abstractSubSkill) {
        return RankUtils.getRank(player, abstractSubSkill) >= n;
    }

    public static int getRank(Player player, SubSkillType subSkillType) {
        String string = subSkillType.toString();
        int n = subSkillType.getNumRanks();
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        if (n == 0) {
            return -1;
        }
        if (subSkillRanks.get(string) == null && n > 0) {
            RankUtils.addRanks(subSkillType);
        }
        HashMap<Integer, Integer> hashMap = subSkillRanks.get(string);
        if (UserManager.getPlayer(player) == null) {
            return 0;
        }
        int n2 = UserManager.getPlayer(player).getSkillLevel(subSkillType.getParentSkill());
        for (int i = 0; i < n; ++i) {
            int n3 = n - i;
            int n4 = RankUtils.getRankUnlockLevel(subSkillType, n3);
            if (n3 == 0) {
                return 0;
            }
            if (n2 < n4) continue;
            return n3;
        }
        return 0;
    }

    public static int getRank(Player player, AbstractSubSkill abstractSubSkill) {
        String string = abstractSubSkill.getConfigKeyName();
        int n = abstractSubSkill.getNumRanks();
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        if (n == 0) {
            return -1;
        }
        if (subSkillRanks.get(string) == null && n > 0) {
            RankUtils.addRanks(abstractSubSkill);
        }
        HashMap<Integer, Integer> hashMap = subSkillRanks.get(string);
        if (UserManager.getPlayer(player) == null) {
            return 0;
        }
        int n2 = UserManager.getPlayer(player).getSkillLevel(abstractSubSkill.getPrimarySkill());
        for (int i = 0; i < n; ++i) {
            int n3 = n - i;
            int n4 = RankUtils.getRankUnlockLevel(abstractSubSkill, n3);
            if (n3 == 0) {
                return 0;
            }
            if (n2 < n4) continue;
            return n3;
        }
        return 0;
    }

    private static void addRank(AbstractSubSkill abstractSubSkill, int n) {
        RankUtils.initMaps(abstractSubSkill.getConfigKeyName());
        HashMap<Integer, Integer> hashMap = subSkillRanks.get(abstractSubSkill.getConfigKeyName());
        hashMap.put(n, RankUtils.getRankUnlockLevel(abstractSubSkill, n));
    }

    @Deprecated
    private static void addRank(SubSkillType subSkillType, int n) {
        RankUtils.initMaps(subSkillType.toString());
        HashMap<Integer, Integer> hashMap = subSkillRanks.get(subSkillType.toString());
        hashMap.put(n, RankUtils.getRankUnlockLevel(subSkillType, n));
    }

    private static void initMaps(String string) {
        if (subSkillRanks == null) {
            subSkillRanks = new HashMap();
        }
        if (subSkillRanks.get(string) == null) {
            subSkillRanks.put(string, new HashMap());
        }
    }

    @Deprecated
    public static int getRankUnlockLevel(SubSkillType subSkillType, int n) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, n);
    }

    public static int getRankUnlockLevel(AbstractSubSkill abstractSubSkill, int n) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, n);
    }

    public static int getUnlockLevel(SubSkillType subSkillType) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(subSkillType, 1);
    }

    public static int getUnlockLevel(AbstractSubSkill abstractSubSkill) {
        return RankConfig.getInstance().getSubSkillUnlockLevel(abstractSubSkill, 1);
    }

    public static int getHighestRank(SubSkillType subSkillType) {
        return subSkillType.getNumRanks();
    }

    public static String getHighestRankStr(SubSkillType subSkillType) {
        return String.valueOf(subSkillType.getNumRanks());
    }

    public static int getHighestRank(AbstractSubSkill abstractSubSkill) {
        return abstractSubSkill.getNumRanks();
    }

    public static int getSuperAbilityUnlockRequirement(SuperAbilityType superAbilityType) {
        return RankUtils.getRankUnlockLevel(superAbilityType.getSubSkillTypeDefinition(), 1);
    }

    public static boolean isPlayerMaxRankInSubSkill(Player player, SubSkillType subSkillType) {
        int n;
        int n2 = RankUtils.getRank(player, subSkillType);
        return n2 == (n = RankUtils.getHighestRank(subSkillType));
    }

    static {
        count = 0;
    }
}

