/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.Config;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public final class ParticleEffectUtils {
    private ParticleEffectUtils() {
    }

    public static void playBleedEffect(LivingEntity livingEntity) {
        if (!Config.getInstance().getBleedEffectEnabled()) {
            return;
        }
        livingEntity.getWorld().playEffect(livingEntity.getEyeLocation(), Effect.STEP_SOUND, (Object)Material.REDSTONE_WIRE);
    }

    public static void playDodgeEffect(Player player) {
        if (!Config.getInstance().getDodgeEffectEnabled()) {
            return;
        }
        ParticleEffectUtils.playSmokeEffect((LivingEntity)player);
    }

    public static void playFluxEffect(Location location) {
        if (!Config.getInstance().getFluxEffectEnabled()) {
            return;
        }
        location.getWorld().playEffect(location, Effect.MOBSPAWNER_FLAMES, 1);
    }

    public static void playSmokeEffect(LivingEntity livingEntity) {
        Location location = livingEntity.getEyeLocation();
        World world = livingEntity.getWorld();
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.SOUTH_EAST);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.SOUTH);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.SOUTH_WEST);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.EAST);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.SELF);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.WEST);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.NORTH_EAST);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.NORTH);
        world.playEffect(location, Effect.SMOKE, (Object)BlockFace.NORTH_WEST);
    }

    public static void playGreaterImpactEffect(LivingEntity livingEntity) {
        if (!Config.getInstance().getGreaterImpactEffectEnabled()) {
            return;
        }
        Location location = livingEntity.getEyeLocation();
        livingEntity.getWorld().createExplosion(location.getX(), location.getY(), location.getZ(), 0.0f, false, false);
    }

    public static void playCallOfTheWildEffect(LivingEntity livingEntity) {
        if (!Config.getInstance().getCallOfTheWildEffectEnabled()) {
            return;
        }
        livingEntity.getWorld().playEffect(livingEntity.getEyeLocation(), Effect.MOBSPAWNER_FLAMES, 1);
    }

    public static void playAbilityEnabledEffect(Player player) {
        if (!Config.getInstance().getAbilityActivationEffectEnabled()) {
            return;
        }
    }

    public static void playAbilityDisabledEffect(Player player) {
        if (!Config.getInstance().getAbilityDeactivationEffectEnabled()) {
            return;
        }
    }

    private static boolean hasHeadRoom(Player player) {
        boolean bl = true;
        Block block = player.getEyeLocation().getBlock();
        for (int i = 0; i < 3; ++i) {
            if (block.getRelative(BlockFace.UP, i).isEmpty()) continue;
            bl = false;
            break;
        }
        return bl;
    }
}

