/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.skills;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.XPGainReason;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.meta.OldName;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.fake.FakeEntityDamageByEntityEvent;
import com.gmail.nossr50.events.fake.FakeEntityDamageEvent;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.party.PartyManager;
import com.gmail.nossr50.runnables.skills.AwardCombatXpTask;
import com.gmail.nossr50.skills.SkillManager;
import com.gmail.nossr50.skills.acrobatics.AcrobaticsManager;
import com.gmail.nossr50.skills.archery.ArcheryManager;
import com.gmail.nossr50.skills.axes.AxesManager;
import com.gmail.nossr50.skills.swords.SwordsManager;
import com.gmail.nossr50.skills.taming.TamingManager;
import com.gmail.nossr50.skills.unarmed.UnarmedManager;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.ItemUtils;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.MobHealthbarUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.NotificationManager;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.RankUtils;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Animals;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public final class CombatUtils {
    private CombatUtils() {
    }

    private static void processSwordCombat(LivingEntity livingEntity, Player player, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        SwordsManager swordsManager = mcMMOPlayer.getSwordsManager();
        double d2 = d = entityDamageByEntityEvent.getDamage();
        Map<EntityDamageEvent.DamageModifier, Double> map = CombatUtils.getModifiers((EntityDamageEvent)entityDamageByEntityEvent);
        if (swordsManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.SWORDS);
        }
        if (livingEntity.getHealth() - entityDamageByEntityEvent.getFinalDamage() >= 1.0 && swordsManager.canUseRupture()) {
            swordsManager.ruptureCheck(livingEntity);
        }
        if (swordsManager.canUseStab()) {
            d2 += swordsManager.getStabDamage();
        }
        if (swordsManager.canUseSerratedStrike()) {
            swordsManager.serratedStrikes(livingEntity, d, map);
        }
        if (CombatUtils.canUseLimitBreak(player, livingEntity, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK)) {
            d2 += (double)CombatUtils.getLimitBreakDamage(player, livingEntity, SubSkillType.SWORDS_SWORDS_LIMIT_BREAK);
        }
        CombatUtils.applyScaledModifiers(d, d2, entityDamageByEntityEvent);
        CombatUtils.startGainXp(mcMMOPlayer, livingEntity, PrimarySkillType.SWORDS);
    }

    private static void processAxeCombat(LivingEntity livingEntity, Player player, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double d2 = d = entityDamageByEntityEvent.getDamage();
        Map<EntityDamageEvent.DamageModifier, Double> map = CombatUtils.getModifiers((EntityDamageEvent)entityDamageByEntityEvent);
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        AxesManager axesManager = mcMMOPlayer.getAxesManager();
        if (axesManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.AXES);
        }
        if (axesManager.canUseAxeMastery()) {
            d2 += axesManager.axeMastery();
        }
        if (axesManager.canImpact(livingEntity)) {
            axesManager.impactCheck(livingEntity);
        } else if (axesManager.canGreaterImpact(livingEntity)) {
            d2 += axesManager.greaterImpact(livingEntity);
        }
        if (axesManager.canUseSkullSplitter(livingEntity)) {
            axesManager.skullSplitterCheck(livingEntity, d, map);
        }
        if (axesManager.canCriticalHit(livingEntity)) {
            d2 += axesManager.criticalHit(livingEntity, d2);
        }
        if (CombatUtils.canUseLimitBreak(player, livingEntity, SubSkillType.AXES_AXES_LIMIT_BREAK)) {
            d2 += (double)CombatUtils.getLimitBreakDamage(player, livingEntity, SubSkillType.AXES_AXES_LIMIT_BREAK);
        }
        CombatUtils.applyScaledModifiers(d, d2, entityDamageByEntityEvent);
        CombatUtils.startGainXp(mcMMOPlayer, livingEntity, PrimarySkillType.AXES);
    }

    private static void processUnarmedCombat(LivingEntity livingEntity, Player player, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        if (entityDamageByEntityEvent.getCause() == EntityDamageEvent.DamageCause.THORNS) {
            return;
        }
        double d2 = d = entityDamageByEntityEvent.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        UnarmedManager unarmedManager = mcMMOPlayer.getUnarmedManager();
        if (unarmedManager.canActivateAbility()) {
            mcMMOPlayer.checkAbilityActivation(PrimarySkillType.UNARMED);
        }
        if (unarmedManager.isPunchingCooldownOver()) {
            if (unarmedManager.canUseIronArm()) {
                d2 += unarmedManager.ironArm();
            }
            if (unarmedManager.canUseBerserk()) {
                d2 += unarmedManager.berserkDamage(d2);
            }
            if (unarmedManager.canDisarm(livingEntity)) {
                unarmedManager.disarmCheck((Player)livingEntity);
            }
            if (CombatUtils.canUseLimitBreak(player, livingEntity, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK)) {
                d2 += (double)CombatUtils.getLimitBreakDamage(player, livingEntity, SubSkillType.UNARMED_UNARMED_LIMIT_BREAK);
            }
        }
        CombatUtils.applyScaledModifiers(d, d2, entityDamageByEntityEvent);
        CombatUtils.startGainXp(mcMMOPlayer, livingEntity, PrimarySkillType.UNARMED);
        unarmedManager.setLastAttacked(System.currentTimeMillis());
    }

    private static void processTamingCombat(LivingEntity livingEntity, Player player, Wolf wolf, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        double d;
        double d2 = d = entityDamageByEntityEvent.getDamage();
        if (player != null && player.isOnline() && player.isValid()) {
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
            if (mcMMOPlayer == null) {
                return;
            }
            TamingManager tamingManager = mcMMOPlayer.getTamingManager();
            if (tamingManager.canUseFastFoodService()) {
                tamingManager.fastFoodService(wolf, entityDamageByEntityEvent.getDamage());
            }
            tamingManager.pummel(livingEntity, wolf);
            if (tamingManager.canUseSharpenedClaws()) {
                d2 += tamingManager.sharpenedClaws();
            }
            if (tamingManager.canUseGore()) {
                d2 += tamingManager.gore(livingEntity, d);
            }
            CombatUtils.applyScaledModifiers(d, d2, entityDamageByEntityEvent);
            CombatUtils.startGainXp(mcMMOPlayer, livingEntity, PrimarySkillType.TAMING);
        }
    }

    private static void processArcheryCombat(LivingEntity livingEntity, Player player, EntityDamageByEntityEvent entityDamageByEntityEvent, Arrow arrow) {
        UnarmedManager unarmedManager;
        double d = entityDamageByEntityEvent.getDamage();
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        ArcheryManager archeryManager = mcMMOPlayer.getArcheryManager();
        double d2 = entityDamageByEntityEvent.getDamage();
        if (livingEntity instanceof Player && PrimarySkillType.UNARMED.getPVPEnabled() && (unarmedManager = UserManager.getPlayer((Player)livingEntity).getUnarmedManager()).canDeflect()) {
            entityDamageByEntityEvent.setCancelled(unarmedManager.deflectCheck());
            if (entityDamageByEntityEvent.isCancelled()) {
                return;
            }
        }
        if (archeryManager.canSkillShot()) {
            d2 += archeryManager.skillShot(d);
        }
        if (archeryManager.canDaze(livingEntity)) {
            d2 += archeryManager.daze((Player)livingEntity);
        }
        if (!arrow.hasMetadata("mcMMO: Infinite Arrow") && archeryManager.canRetrieveArrows()) {
            archeryManager.retrieveArrows(livingEntity, (Projectile)arrow);
        }
        if (CombatUtils.canUseLimitBreak(player, livingEntity, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK)) {
            d2 += (double)CombatUtils.getLimitBreakDamage(player, livingEntity, SubSkillType.ARCHERY_ARCHERY_LIMIT_BREAK);
        }
        double d3 = archeryManager.distanceXpBonusMultiplier(livingEntity, (Entity)arrow);
        double d4 = 1.0;
        if (arrow.hasMetadata("mcMMO: Bow Force")) {
            d4 = ((MetadataValue)arrow.getMetadata("mcMMO: Bow Force").get(0)).asDouble();
        }
        CombatUtils.applyScaledModifiers(d, d2, entityDamageByEntityEvent);
        CombatUtils.startGainXp(mcMMOPlayer, livingEntity, PrimarySkillType.ARCHERY, d4 * d3);
    }

    public static void processCombatAttack(EntityDamageByEntityEvent entityDamageByEntityEvent, Entity entity, LivingEntity livingEntity) {
        Object object;
        SkillManager skillManager;
        McMMOPlayer mcMMOPlayer;
        Player player;
        Entity entity2 = entityDamageByEntityEvent.getDamager();
        EntityType entityType = entity2.getType();
        if (livingEntity instanceof Player) {
            if (Misc.isNPCEntityExcludingVillagers((Entity)livingEntity)) {
                return;
            }
            player = (Player)livingEntity;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            mcMMOPlayer = UserManager.getPlayer(player);
            skillManager = mcMMOPlayer.getAcrobaticsManager();
            if (((AcrobaticsManager)skillManager).canDodge((Entity)livingEntity)) {
                entityDamageByEntityEvent.setDamage(((AcrobaticsManager)skillManager).dodgeCheck(entityDamageByEntityEvent.getDamage()));
            }
            if (ItemUtils.isSword(player.getInventory().getItemInMainHand())) {
                if (!PrimarySkillType.SWORDS.shouldProcess((Entity)livingEntity)) {
                    return;
                }
                object = mcMMOPlayer.getSwordsManager();
                if (((SwordsManager)object).canUseCounterAttack(entity2)) {
                    ((SwordsManager)object).counterAttackChecks((LivingEntity)entity2, entityDamageByEntityEvent.getDamage());
                }
            }
        }
        if (entity instanceof Player && entityType == EntityType.PLAYER) {
            player = (Player)entity;
            if (!UserManager.hasPlayerDataKey((Entity)player)) {
                return;
            }
            mcMMOPlayer = player.getInventory().getItemInMainHand();
            if (livingEntity instanceof Tameable) {
                if (mcMMOPlayer.getType() == Material.BONE && ((TamingManager)(skillManager = UserManager.getPlayer(player).getTamingManager())).canUseBeastLore()) {
                    ((TamingManager)skillManager).beastLore(livingEntity);
                    entityDamageByEntityEvent.setCancelled(true);
                    return;
                }
                if (CombatUtils.isFriendlyPet(player, (Tameable)livingEntity)) {
                    return;
                }
            }
            if (ItemUtils.isSword((ItemStack)mcMMOPlayer)) {
                if (!PrimarySkillType.SWORDS.shouldProcess((Entity)livingEntity)) {
                    return;
                }
                if (PrimarySkillType.SWORDS.getPermissions(player)) {
                    CombatUtils.processSwordCombat(livingEntity, player, entityDamageByEntityEvent);
                }
            } else if (ItemUtils.isAxe((ItemStack)mcMMOPlayer)) {
                if (!PrimarySkillType.AXES.shouldProcess((Entity)livingEntity)) {
                    return;
                }
                if (PrimarySkillType.AXES.getPermissions(player)) {
                    CombatUtils.processAxeCombat(livingEntity, player, entityDamageByEntityEvent);
                }
            } else if (ItemUtils.isUnarmed((ItemStack)mcMMOPlayer)) {
                if (!PrimarySkillType.UNARMED.shouldProcess((Entity)livingEntity)) {
                    return;
                }
                if (PrimarySkillType.UNARMED.getPermissions(player)) {
                    CombatUtils.processUnarmedCombat(livingEntity, player, entityDamageByEntityEvent);
                }
            }
        } else if (entityType == EntityType.WOLF) {
            player = (Wolf)entity2;
            mcMMOPlayer = player.getOwner();
            if (mcMMOPlayer != null && mcMMOPlayer instanceof Player && PrimarySkillType.TAMING.shouldProcess((Entity)livingEntity) && !Misc.isNPCEntityExcludingVillagers((Entity)(skillManager = (Player)mcMMOPlayer)) && PrimarySkillType.TAMING.getPermissions((Player)skillManager)) {
                CombatUtils.processTamingCombat(livingEntity, (Player)skillManager, (Wolf)player, entityDamageByEntityEvent);
            }
        } else if (entityType == EntityType.ARROW && (mcMMOPlayer = (player = (Arrow)entity2).getShooter()) != null && mcMMOPlayer instanceof Player && PrimarySkillType.ARCHERY.shouldProcess((Entity)livingEntity)) {
            skillManager = (Player)mcMMOPlayer;
            if (!Misc.isNPCEntityExcludingVillagers((Entity)skillManager) && PrimarySkillType.ARCHERY.getPermissions((Player)skillManager)) {
                CombatUtils.processArcheryCombat(livingEntity, (Player)skillManager, entityDamageByEntityEvent, (Arrow)player);
            }
            if (livingEntity.getType() != EntityType.CREEPER && !Misc.isNPCEntityExcludingVillagers((Entity)skillManager) && PrimarySkillType.TAMING.getPermissions((Player)skillManager)) {
                object = UserManager.getPlayer((Player)skillManager);
                TamingManager tamingManager = ((McMMOPlayer)object).getTamingManager();
                tamingManager.attackTarget(livingEntity);
            }
        }
    }

    public static void fixNames(LivingEntity livingEntity) {
        List list = livingEntity.getMetadata("mcMMO_oldName");
        if (list.size() <= 0) {
            return;
        }
        if (list != null) {
            OldName oldName = (OldName)((Object)list.get(0));
            livingEntity.setCustomName(oldName.asString());
            livingEntity.setCustomNameVisible(false);
        }
    }

    public static int getLimitBreakDamage(Player player, LivingEntity livingEntity, SubSkillType subSkillType) {
        if (livingEntity instanceof Player) {
            Player player2 = (Player)livingEntity;
            return CombatUtils.getLimitBreakDamageAgainstQuality(player, subSkillType, CombatUtils.getArmorQualityLevel(player2));
        }
        return CombatUtils.getLimitBreakDamageAgainstQuality(player, subSkillType, 1000);
    }

    public static int getLimitBreakDamageAgainstQuality(Player player, SubSkillType subSkillType, int n) {
        int n2 = RankUtils.getRank(player, subSkillType);
        if (n <= 4) {
            n2 = (int)((double)n2 * 0.25);
        } else if (n <= 8) {
            n2 = (int)((double)n2 * 0.5);
        } else if (n <= 12) {
            n2 = (int)((double)n2 * 0.75);
        }
        return n2;
    }

    public static int getArmorQualityLevel(Player player) {
        int n = 0;
        for (ItemStack itemStack : player.getInventory().getArmorContents()) {
            if (itemStack == null) continue;
            n += CombatUtils.getArmorQuality(itemStack);
        }
        return n;
    }

    private static int getArmorQuality(ItemStack itemStack) {
        boolean bl = false;
        switch (itemStack.getType()) {
            case LEATHER_HELMET: 
            case LEATHER_BOOTS: 
            case LEATHER_CHESTPLATE: 
            case LEATHER_LEGGINGS: {
                return 1;
            }
            case IRON_HELMET: 
            case IRON_BOOTS: 
            case IRON_CHESTPLATE: 
            case IRON_LEGGINGS: {
                return 2;
            }
            case GOLDEN_HELMET: 
            case GOLDEN_BOOTS: 
            case GOLDEN_CHESTPLATE: 
            case GOLDEN_LEGGINGS: {
                return 3;
            }
            case DIAMOND_HELMET: 
            case DIAMOND_BOOTS: 
            case DIAMOND_CHESTPLATE: 
            case DIAMOND_LEGGINGS: {
                return 6;
            }
        }
        return 1;
    }

    public static boolean canUseLimitBreak(Player player, LivingEntity livingEntity, SubSkillType subSkillType) {
        if (livingEntity instanceof Player || AdvancedConfig.getInstance().canApplyLimitBreakPVE()) {
            return RankUtils.hasUnlockedSubskill(player, subSkillType) && Permissions.isSubSkillEnabled((Permissible)player, subSkillType);
        }
        return false;
    }

    @Deprecated
    public static void dealDamage(LivingEntity livingEntity, double d) {
        CombatUtils.dealDamage(livingEntity, d, EntityDamageEvent.DamageCause.CUSTOM, null);
    }

    @Deprecated
    public static void dealDamage(LivingEntity livingEntity, double d, LivingEntity livingEntity2) {
        CombatUtils.dealDamage(livingEntity, d, EntityDamageEvent.DamageCause.CUSTOM, (Entity)livingEntity2);
    }

    public static void dealDamage(LivingEntity livingEntity, double d, Map<EntityDamageEvent.DamageModifier, Double> map, LivingEntity livingEntity2) {
        if (livingEntity.isDead()) {
            return;
        }
        livingEntity.damage(CombatUtils.getFakeDamageFinalResult((Entity)livingEntity2, (Entity)livingEntity, d, map));
    }

    @Deprecated
    public static void dealDamage(LivingEntity livingEntity, double d, EntityDamageEvent.DamageCause damageCause, Entity entity) {
        if (livingEntity.isDead()) {
            return;
        }
        if (CombatUtils.canDamage(entity, (Entity)livingEntity, damageCause, d)) {
            livingEntity.damage(d);
        }
    }

    public static void dealNoInvulnerabilityTickDamage(LivingEntity livingEntity, double d, Entity entity) {
        if (livingEntity.isDead()) {
            return;
        }
        boolean bl = livingEntity.getMetadata("mcMMO: Custom Damage").size() != 0;
        livingEntity.setMetadata("mcMMO: Custom Damage", (MetadataValue)mcMMO.metadataValue);
        int n = livingEntity.getNoDamageTicks();
        livingEntity.setNoDamageTicks(0);
        livingEntity.damage(d, entity);
        livingEntity.setNoDamageTicks(n);
        if (!bl) {
            livingEntity.removeMetadata("mcMMO: Custom Damage", (Plugin)mcMMO.p);
        }
    }

    public static void dealNoInvulnerabilityTickDamageRupture(LivingEntity livingEntity, double d, Entity entity, int n) {
        if (livingEntity.isDead()) {
            return;
        }
        CombatUtils.dealNoInvulnerabilityTickDamage(livingEntity, d, entity);
    }

    public static void applyAbilityAoE(Player player, LivingEntity livingEntity, double d, Map<EntityDamageEvent.DamageModifier, Double> map, PrimarySkillType primarySkillType) {
        int n = CombatUtils.getTier(player.getInventory().getItemInMainHand());
        double d2 = Math.max(d, 1.0);
        for (Entity entity : livingEntity.getNearbyEntities(2.5, 2.5, 2.5)) {
            if (n <= 0) break;
            if (Misc.isNPCEntityExcludingVillagers(entity) || !(entity instanceof LivingEntity) || !CombatUtils.shouldBeAffected(player, entity)) continue;
            LivingEntity livingEntity2 = (LivingEntity)entity;
            EventUtils.callFakeArmSwingEvent(player);
            switch (primarySkillType) {
                case SWORDS: {
                    if (entity instanceof Player) {
                        NotificationManager.sendPlayerInformation((Player)entity, NotificationType.SUBSKILL_MESSAGE, "Swords.Combat.SS.Struck");
                    }
                    UserManager.getPlayer(player).getSwordsManager().ruptureCheck(livingEntity);
                    break;
                }
                case AXES: {
                    if (!(entity instanceof Player)) break;
                    NotificationManager.sendPlayerInformation((Player)entity, NotificationType.SUBSKILL_MESSAGE, "Axes.Combat.SS.Struck");
                    break;
                }
            }
            CombatUtils.dealDamage(livingEntity2, d2, (LivingEntity)player);
            --n;
        }
    }

    public static void startGainXp(McMMOPlayer mcMMOPlayer, LivingEntity livingEntity, PrimarySkillType primarySkillType) {
        CombatUtils.startGainXp(mcMMOPlayer, livingEntity, primarySkillType, 1.0);
    }

    private static void startGainXp(McMMOPlayer mcMMOPlayer, LivingEntity livingEntity, PrimarySkillType primarySkillType, double d) {
        XPGainReason xPGainReason;
        double d2 = 0.0;
        if (livingEntity instanceof Player) {
            if (!ExperienceConfig.getInstance().getExperienceGainsPlayerVersusPlayerEnabled() || PartyManager.inSameParty(mcMMOPlayer.getPlayer(), (Player)livingEntity)) {
                return;
            }
            xPGainReason = XPGainReason.PVP;
            Player player = (Player)livingEntity;
            if (player.isOnline() && SkillUtils.cooldownExpired(mcMMOPlayer.getRespawnATS(), 5)) {
                d2 = 20.0 * ExperienceConfig.getInstance().getPlayerVersusPlayerXP();
            }
        } else {
            if (mcMMO.getModManager().isCustomEntity((Entity)livingEntity)) {
                d2 = mcMMO.getModManager().getEntity((Entity)livingEntity).getXpMultiplier();
            } else if (livingEntity instanceof Animals) {
                EntityType entityType = livingEntity.getType();
                d2 = ExperienceConfig.getInstance().getAnimalsXP(entityType);
            } else if (livingEntity instanceof Monster) {
                EntityType entityType = livingEntity.getType();
                d2 = ExperienceConfig.getInstance().getCombatXP(entityType);
            } else {
                EntityType entityType = livingEntity.getType();
                if (ExperienceConfig.getInstance().hasCombatXP(entityType)) {
                    if (entityType == EntityType.IRON_GOLEM) {
                        if (!((IronGolem)livingEntity).isPlayerCreated()) {
                            d2 = ExperienceConfig.getInstance().getCombatXP(entityType);
                        }
                    } else {
                        d2 = ExperienceConfig.getInstance().getCombatXP(entityType);
                    }
                } else {
                    d2 = 1.0;
                    mcMMO.getModManager().addCustomEntity((Entity)livingEntity);
                }
            }
            if (livingEntity.hasMetadata("mcMMO: Spawned Entity") || livingEntity.hasMetadata("ES")) {
                d2 *= ExperienceConfig.getInstance().getSpawnedMobXpMultiplier();
            }
            if (livingEntity.hasMetadata("mcMMO: Bred Animal")) {
                d2 *= ExperienceConfig.getInstance().getBredMobXpMultiplier();
            }
            xPGainReason = XPGainReason.PVE;
            d2 *= 10.0;
        }
        if ((d2 *= d) != 0.0) {
            new AwardCombatXpTask(mcMMOPlayer, primarySkillType, d2, livingEntity, xPGainReason).runTaskLater((Plugin)mcMMO.p, 0L);
        }
    }

    private static boolean shouldBeAffected(Player player, Entity entity) {
        if (entity instanceof Player) {
            Player player2 = (Player)entity;
            if (UserManager.getPlayer(player2) == null) {
                return true;
            }
            if (!player2.getWorld().getPVP() || player2 == player || UserManager.getPlayer(player2).getGodMode()) {
                return false;
            }
            if (!(!PartyManager.inSameParty(player, player2) && !PartyManager.areAllies(player, player2) || Permissions.friendlyFire((Permissible)player) && Permissions.friendlyFire((Permissible)player2))) {
                return false;
            }
            if (!player.canSee(player2)) {
                return false;
            }
            if (player2.getGameMode() == GameMode.SPECTATOR) {
                return false;
            }
            if (CombatUtils.getFakeDamageFinalResult((Entity)player, entity, 1.0) == 0.0) {
                return false;
            }
        } else if (entity instanceof Tameable && CombatUtils.isFriendlyPet(player, (Tameable)entity)) {
            Player player3 = (Player)((Tameable)entity).getOwner();
            if (!Permissions.friendlyFire((Permissible)player) || !Permissions.friendlyFire((Permissible)player3)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isInvincible(LivingEntity livingEntity, double d) {
        return (float)livingEntity.getNoDamageTicks() > (float)livingEntity.getMaximumNoDamageTicks() / 2.0f && d <= livingEntity.getLastDamage();
    }

    public static boolean isFriendlyPet(Player player, Tameable tameable) {
        AnimalTamer animalTamer;
        if (tameable.isTamed() && (animalTamer = tameable.getOwner()) instanceof Player) {
            Player player2 = (Player)animalTamer;
            return player2 == player || PartyManager.inSameParty(player, player2) || PartyManager.areAllies(player, player2);
        }
        return false;
    }

    @Deprecated
    public static double getFakeDamageFinalResult(Entity entity, Entity entity2, double d) {
        return CombatUtils.getFakeDamageFinalResult(entity, entity2, EntityDamageEvent.DamageCause.ENTITY_ATTACK, new EnumMap<EntityDamageEvent.DamageModifier, Double>((Map<EntityDamageEvent.DamageModifier, Double>)ImmutableMap.of((Object)EntityDamageEvent.DamageModifier.BASE, (Object)d)));
    }

    @Deprecated
    public static double getFakeDamageFinalResult(Entity entity, Entity entity2, EntityDamageEvent.DamageCause damageCause, double d) {
        EntityDamageEvent entityDamageEvent = CombatUtils.sendEntityDamageEvent(entity, entity2, damageCause, d);
        if (entityDamageEvent.isCancelled()) {
            return 0.0;
        }
        return entityDamageEvent.getFinalDamage();
    }

    public static boolean canDamage(Entity entity, Entity entity2, EntityDamageEvent.DamageCause damageCause, double d) {
        EntityDamageEvent entityDamageEvent = CombatUtils.sendEntityDamageEvent(entity, entity2, damageCause, d);
        return !entityDamageEvent.isCancelled();
    }

    public static EntityDamageEvent sendEntityDamageEvent(Entity entity, Entity entity2, EntityDamageEvent.DamageCause damageCause, double d) {
        Object object = entity == null ? new FakeEntityDamageEvent(entity2, damageCause, d) : new FakeEntityDamageByEntityEvent(entity, entity2, damageCause, d);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)object);
        return object;
    }

    public static double getFakeDamageFinalResult(Entity entity, Entity entity2, Map<EntityDamageEvent.DamageModifier, Double> map) {
        return CombatUtils.getFakeDamageFinalResult(entity, entity2, EntityDamageEvent.DamageCause.ENTITY_ATTACK, map);
    }

    public static double getFakeDamageFinalResult(Entity entity, Entity entity2, double d, Map<EntityDamageEvent.DamageModifier, Double> map) {
        return CombatUtils.getFakeDamageFinalResult(entity, entity2, EntityDamageEvent.DamageCause.ENTITY_ATTACK, CombatUtils.getScaledModifiers(d, map));
    }

    public static double getFakeDamageFinalResult(Entity entity, Entity entity2, EntityDamageEvent.DamageCause damageCause, Map<EntityDamageEvent.DamageModifier, Double> map) {
        Object object = entity == null ? new FakeEntityDamageEvent(entity2, damageCause, map) : new FakeEntityDamageByEntityEvent(entity, entity2, damageCause, map);
        mcMMO.p.getServer().getPluginManager().callEvent((Event)object);
        if (object.isCancelled()) {
            return 0.0;
        }
        return object.getFinalDamage();
    }

    private static Map<EntityDamageEvent.DamageModifier, Double> getModifiers(EntityDamageEvent entityDamageEvent) {
        HashMap<EntityDamageEvent.DamageModifier, Double> hashMap = new HashMap<EntityDamageEvent.DamageModifier, Double>();
        for (EntityDamageEvent.DamageModifier damageModifier : EntityDamageEvent.DamageModifier.values()) {
            hashMap.put(damageModifier, entityDamageEvent.getDamage(damageModifier));
        }
        return hashMap;
    }

    private static Map<EntityDamageEvent.DamageModifier, Double> getScaledModifiers(double d, Map<EntityDamageEvent.DamageModifier, Double> map) {
        HashMap<EntityDamageEvent.DamageModifier, Double> hashMap = new HashMap<EntityDamageEvent.DamageModifier, Double>();
        for (EntityDamageEvent.DamageModifier damageModifier : map.keySet()) {
            if (damageModifier == EntityDamageEvent.DamageModifier.BASE) {
                hashMap.put(damageModifier, d);
                continue;
            }
            hashMap.put(damageModifier, d * map.get(damageModifier));
        }
        return hashMap;
    }

    public static EntityDamageByEntityEvent applyScaledModifiers(double d, double d2, EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (d == d2) {
            return entityDamageByEntityEvent;
        }
        for (EntityDamageEvent.DamageModifier damageModifier : EntityDamageEvent.DamageModifier.values()) {
            if (!entityDamageByEntityEvent.isApplicable(damageModifier)) continue;
            if (damageModifier == EntityDamageEvent.DamageModifier.BASE) {
                entityDamageByEntityEvent.setDamage(damageModifier, d2);
                continue;
            }
            entityDamageByEntityEvent.setDamage(damageModifier, d2 / d * entityDamageByEntityEvent.getDamage(damageModifier));
        }
        return entityDamageByEntityEvent;
    }

    private static int getTier(ItemStack itemStack) {
        int n = 0;
        if (ItemUtils.isWoodTool(itemStack)) {
            n = 1;
        } else if (ItemUtils.isStoneTool(itemStack)) {
            n = 2;
        } else if (ItemUtils.isIronTool(itemStack)) {
            n = 3;
        } else if (ItemUtils.isGoldTool(itemStack)) {
            n = 1;
        } else if (ItemUtils.isDiamondTool(itemStack)) {
            n = 4;
        } else if (mcMMO.getModManager().isCustomTool(itemStack)) {
            n = mcMMO.getModManager().getTool(itemStack).getTier();
        }
        return n;
    }

    public static void handleHealthbars(Entity entity, LivingEntity livingEntity, double d, mcMMO mcMMO2) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (Misc.isNPCEntityExcludingVillagers((Entity)player) || Misc.isNPCEntityExcludingVillagers((Entity)livingEntity)) {
            return;
        }
        if (!player.hasMetadata("mcMMO: Player Data")) {
            return;
        }
        MobHealthbarUtils.handleMobHealthbars(livingEntity, d, mcMMO2);
    }
}

