/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.scoreboards;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardMakeboardEvent;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardObjectiveEvent;
import com.gmail.nossr50.events.scoreboard.McMMOScoreboardRevertEvent;
import com.gmail.nossr50.events.scoreboard.ScoreboardEventReason;
import com.gmail.nossr50.events.scoreboard.ScoreboardObjectiveEventReason;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.skills.child.FamilyTree;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardManager;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class ScoreboardWrapper {
    public final String playerName;
    public final Player player;
    private final Scoreboard scoreboard;
    private boolean tippedKeep = false;
    private boolean tippedClear = false;
    private ScoreboardManager.SidebarType sidebarType;
    private Objective sidebarObjective;
    private Objective powerObjective;
    private Scoreboard oldBoard = null;
    public String targetPlayer = null;
    public PrimarySkillType targetSkill = null;
    private PlayerProfile targetProfile = null;
    public int leaderboardPage = -1;
    public BukkitTask updateTask = null;
    public BukkitTask revertTask = null;
    public BukkitTask cooldownTask = null;

    private ScoreboardWrapper(Player player, Scoreboard scoreboard) {
        this.player = player;
        this.playerName = player.getName();
        this.scoreboard = scoreboard;
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.sidebarObjective = this.scoreboard.registerNewObjective("mcmmo_sidebar", "dummy");
        this.powerObjective = this.scoreboard.registerNewObjective("mcmmo_pwrlvl", "dummy");
        if (Config.getInstance().getPowerLevelTagsEnabled()) {
            this.powerObjective.setDisplayName(ScoreboardManager.TAG_POWER_LEVEL);
            this.powerObjective.setDisplaySlot(DisplaySlot.BELOW_NAME);
            for (McMMOPlayer mcMMOPlayer : UserManager.getPlayers()) {
                this.powerObjective.getScore(mcMMOPlayer.getProfile().getPlayerName()).setScore(mcMMOPlayer.getPowerLevel());
            }
        }
    }

    public static ScoreboardWrapper create(Player player) {
        McMMOScoreboardMakeboardEvent mcMMOScoreboardMakeboardEvent = new McMMOScoreboardMakeboardEvent(mcMMO.p.getServer().getScoreboardManager().getNewScoreboard(), player.getScoreboard(), player, ScoreboardEventReason.CREATING_NEW_SCOREBOARD);
        player.getServer().getPluginManager().callEvent((Event)mcMMOScoreboardMakeboardEvent);
        return new ScoreboardWrapper(mcMMOScoreboardMakeboardEvent.getTargetPlayer(), mcMMOScoreboardMakeboardEvent.getTargetBoard());
    }

    public void doSidebarUpdateSoon() {
        if (this.updateTask == null) {
            this.updateTask = new ScoreboardQuickUpdate().runTaskLater((Plugin)mcMMO.p, 2L);
        }
    }

    private void startCooldownUpdating() {
        if (this.cooldownTask == null) {
            this.cooldownTask = new ScoreboardCooldownTask().runTaskTimer((Plugin)mcMMO.p, 100L, 100L);
        }
    }

    private void stopCooldownUpdating() {
        if (this.cooldownTask != null) {
            try {
                this.cooldownTask.cancel();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.cooldownTask = null;
        }
    }

    public boolean isSkillScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.SKILL_BOARD;
    }

    public boolean isCooldownScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
    }

    public boolean isStatsScoreboard() {
        return this.sidebarType == ScoreboardManager.SidebarType.STATS_BOARD;
    }

    public void setOldScoreboard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        Scoreboard scoreboard = player.getScoreboard();
        if (scoreboard == this.scoreboard) {
            if (this.oldBoard == null) {
                this.oldBoard = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard();
            }
        } else {
            this.oldBoard = scoreboard;
        }
    }

    public void showBoardWithNoRevert() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = null;
    }

    public void showBoardAndScheduleRevert(int n) {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.revertTask != null) {
            this.revertTask.cancel();
        }
        player.setScoreboard(this.scoreboard);
        this.revertTask = new ScoreboardChangeTask().runTaskLater((Plugin)mcMMO.p, n);
        if (UserManager.getPlayer(this.playerName) == null) {
            return;
        }
        PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
        if (playerProfile.getScoreboardTipsShown() >= Config.getInstance().getTipsAmount()) {
            return;
        }
        if (!this.tippedKeep) {
            this.tippedKeep = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Keep"));
        } else if (!this.tippedClear) {
            this.tippedClear = true;
            player.sendMessage(LocaleLoader.getString("Commands.Scoreboard.Tip.Clear"));
            playerProfile.increaseTipsShown();
        }
    }

    public void tryRevertBoard() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        if (this.oldBoard != null) {
            if (player.getScoreboard() == this.scoreboard) {
                McMMOScoreboardRevertEvent mcMMOScoreboardRevertEvent = new McMMOScoreboardRevertEvent(this.oldBoard, player.getScoreboard(), player, ScoreboardEventReason.REVERTING_BOARD);
                player.getServer().getPluginManager().callEvent((Event)mcMMOScoreboardRevertEvent);
                mcMMOScoreboardRevertEvent.getTargetPlayer().setScoreboard(mcMMOScoreboardRevertEvent.getTargetBoard());
                this.oldBoard = null;
            } else {
                mcMMO.p.debug("Not reverting targetBoard for " + this.playerName + " - targetBoard was changed by another plugin (Consider disabling the mcMMO scoreboards if you don't want them!)");
            }
        }
        this.cancelRevert();
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
    }

    public boolean isBoardShown() {
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return false;
        }
        return player.getScoreboard() == this.scoreboard;
    }

    public void cancelRevert() {
        if (this.revertTask == null) {
            return;
        }
        this.revertTask.cancel();
        this.revertTask = null;
    }

    public void setTypeNone() {
        this.sidebarType = ScoreboardManager.SidebarType.NONE;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective("");
    }

    public void setTypeSkill(PrimarySkillType primarySkillType) {
        this.sidebarType = ScoreboardManager.SidebarType.SKILL_BOARD;
        this.targetSkill = primarySkillType;
        this.targetPlayer = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.skillLabels.get((Object)primarySkillType));
    }

    public void setTypeSelfStats() {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_STATS);
    }

    public void setTypeInspectStats(PlayerProfile playerProfile) {
        this.sidebarType = ScoreboardManager.SidebarType.STATS_BOARD;
        this.targetPlayer = playerProfile.getPlayerName();
        this.targetProfile = playerProfile;
        this.targetSkill = null;
        this.leaderboardPage = -1;
        this.loadObjective(LocaleLoader.getString("Scoreboard.Header.PlayerInspect", this.targetPlayer));
    }

    public void setTypeCooldowns() {
        this.sidebarType = ScoreboardManager.SidebarType.COOLDOWNS_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_COOLDOWNS);
    }

    public void setTypeSelfRank() {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = null;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeInspectRank(String string) {
        this.sidebarType = ScoreboardManager.SidebarType.RANK_BOARD;
        this.targetPlayer = string;
        this.targetSkill = null;
        this.targetProfile = null;
        this.leaderboardPage = -1;
        this.loadObjective(ScoreboardManager.HEADER_RANK);
    }

    public void setTypeTopPower(int n) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = n;
        this.targetSkill = null;
        this.targetPlayer = null;
        this.targetProfile = null;
        int n2 = n * 10;
        int n3 = n2 - 9;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.POWER_LEVEL, n3, n2));
    }

    public void setTypeTop(PrimarySkillType primarySkillType, int n) {
        this.sidebarType = ScoreboardManager.SidebarType.TOP_BOARD;
        this.leaderboardPage = n;
        this.targetSkill = primarySkillType;
        this.targetPlayer = null;
        this.targetProfile = null;
        int n2 = n * 10;
        int n3 = n2 - 9;
        this.loadObjective(String.format("%s (%2d - %2d)", ScoreboardManager.skillLabels.get((Object)primarySkillType), n3, n2));
    }

    protected void loadObjective(String string) {
        McMMOScoreboardObjectiveEvent mcMMOScoreboardObjectiveEvent;
        McMMOScoreboardObjectiveEvent mcMMOScoreboardObjectiveEvent2 = this.callObjectiveEvent(ScoreboardObjectiveEventReason.UNREGISTER_THIS_OBJECTIVE);
        if (!mcMMOScoreboardObjectiveEvent2.isCancelled()) {
            this.sidebarObjective.unregister();
        }
        if (!(mcMMOScoreboardObjectiveEvent = this.callObjectiveEvent(ScoreboardObjectiveEventReason.REGISTER_NEW_OBJECTIVE)).isCancelled()) {
            this.sidebarObjective = mcMMOScoreboardObjectiveEvent.getTargetBoard().registerNewObjective("mcmmo_sidebar", "dummy");
        }
        if (string.length() > 32) {
            string = string.substring(0, 32);
        }
        this.sidebarObjective.setDisplayName(string);
        this.updateSidebar();
        this.sidebarObjective.setDisplaySlot(DisplaySlot.SIDEBAR);
    }

    private McMMOScoreboardObjectiveEvent callObjectiveEvent(ScoreboardObjectiveEventReason scoreboardObjectiveEventReason) {
        McMMOScoreboardObjectiveEvent mcMMOScoreboardObjectiveEvent = new McMMOScoreboardObjectiveEvent(this.sidebarObjective, scoreboardObjectiveEventReason, this.scoreboard, this.scoreboard, this.player, ScoreboardEventReason.OBJECTIVE);
        this.player.getServer().getPluginManager().callEvent((Event)mcMMOScoreboardObjectiveEvent);
        return mcMMOScoreboardObjectiveEvent;
    }

    /*
     * WARNING - void declaration
     */
    private void updateSidebar() {
        try {
            this.updateTask.cancel();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.updateTask = null;
        if (this.sidebarType == ScoreboardManager.SidebarType.NONE) {
            return;
        }
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        if (player == null) {
            ScoreboardManager.cleanup(this);
            return;
        }
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        if (mcMMOPlayer == null) {
            return;
        }
        switch (this.sidebarType) {
            case NONE: {
                break;
            }
            case SKILL_BOARD: {
                int n;
                Validate.notNull((Object)((Object)this.targetSkill));
                if (!this.targetSkill.isChildSkill()) {
                    n = mcMMOPlayer.getSkillXpLevel(this.targetSkill);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_CURRENT_XP).setScore(n);
                    this.sidebarObjective.getScore(ScoreboardManager.LABEL_REMAINING_XP).setScore(mcMMOPlayer.getXpToLevel(this.targetSkill) - n);
                } else {
                    for (PrimarySkillType enum_2 : FamilyTree.getParents(this.targetSkill)) {
                        this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)enum_2)).setScore(mcMMOPlayer.getSkillLevel(enum_2));
                    }
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_LEVEL).setScore(mcMMOPlayer.getSkillLevel(this.targetSkill));
                if (this.targetSkill.getAbility() == null) break;
                if (this.targetSkill == PrimarySkillType.MINING) {
                    Score score = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)SuperAbilityType.SUPER_BREAKER));
                    Score score2 = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)SuperAbilityType.BLAST_MINING));
                    int n2 = Math.max(mcMMOPlayer.calculateTimeRemaining(SuperAbilityType.SUPER_BREAKER), 0);
                    int n3 = Math.max(mcMMOPlayer.calculateTimeRemaining(SuperAbilityType.BLAST_MINING), 0);
                    score.setScore(n2);
                    score2.setScore(n3);
                    n = n2 == 0 && n3 == 0 ? 1 : 0;
                } else {
                    SuperAbilityType playerProfile = this.targetSkill.getAbility();
                    Score score = this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsSkill.get((Object)playerProfile));
                    int n4 = Math.max(mcMMOPlayer.calculateTimeRemaining(playerProfile), 0);
                    score.setScore(n4);
                    int n5 = n = n4 == 0 ? 1 : 0;
                }
                if (n != 0) {
                    this.stopCooldownUpdating();
                    break;
                }
                this.startCooldownUpdating();
                break;
            }
            case COOLDOWNS_BOARD: {
                boolean bl = false;
                for (SuperAbilityType superAbilityType : SuperAbilityType.values()) {
                    int n = Math.max(mcMMOPlayer.calculateTimeRemaining(superAbilityType), 0);
                    if (n != 0) {
                        bl = true;
                    }
                    this.sidebarObjective.getScore(ScoreboardManager.abilityLabelsColored.get((Object)superAbilityType)).setScore(n);
                }
                if (bl) {
                    this.startCooldownUpdating();
                    break;
                }
                this.stopCooldownUpdating();
                break;
            }
            case STATS_BOARD: {
                if (this.targetProfile != null) {
                    PlayerProfile playerProfile = this.targetProfile;
                } else if (this.targetPlayer == null) {
                    PlayerProfile playerProfile = mcMMOPlayer.getProfile();
                } else {
                    PlayerProfile playerProfile = UserManager.getPlayer(this.targetPlayer).getProfile();
                }
                int n = 0;
                for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
                    void var4_14;
                    int n6 = var4_14.getSkillLevel(primarySkillType);
                    n += n6;
                    if (!primarySkillType.getPermissions(player)) continue;
                    this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)primarySkillType)).setScore(n6);
                }
                this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(n);
                break;
            }
            case RANK_BOARD: 
            case TOP_BOARD: {
                break;
            }
        }
    }

    public void acceptRankData(Map<PrimarySkillType, Integer> map) {
        Integer n;
        Player player = mcMMO.p.getServer().getPlayerExact(this.playerName);
        for (PrimarySkillType primarySkillType : PrimarySkillType.NON_CHILD_SKILLS) {
            if (!primarySkillType.getPermissions(player) || (n = map.get((Object)primarySkillType)) == null) continue;
            this.sidebarObjective.getScore(ScoreboardManager.skillLabels.get((Object)primarySkillType)).setScore(n.intValue());
        }
        n = map.get(null);
        if (n != null) {
            this.sidebarObjective.getScore(ScoreboardManager.LABEL_POWER_LEVEL).setScore(n.intValue());
        }
    }

    public void acceptLeaderboardData(List<PlayerStat> list) {
        for (PlayerStat playerStat : list) {
            String string = playerStat.name;
            if (string.equals(this.playerName)) {
                string = ChatColor.GOLD + "--You--";
            }
            this.sidebarObjective.getScore(string).setScore(playerStat.statVal);
        }
    }

    public void updatePowerLevel(Player player, int n) {
        this.powerObjective.getScore(player.getName()).setScore(n);
    }

    private class ScoreboardCooldownTask
    extends BukkitRunnable {
        private ScoreboardCooldownTask() {
        }

        public void run() {
            if (ScoreboardWrapper.this.isBoardShown() && (ScoreboardWrapper.this.isSkillScoreboard() || ScoreboardWrapper.this.isCooldownScoreboard())) {
                ScoreboardWrapper.this.doSidebarUpdateSoon();
            } else {
                ScoreboardWrapper.this.stopCooldownUpdating();
            }
        }
    }

    private class ScoreboardChangeTask
    extends BukkitRunnable {
        private ScoreboardChangeTask() {
        }

        public void run() {
            ScoreboardWrapper.this.tryRevertBoard();
            ScoreboardWrapper.this.revertTask = null;
        }
    }

    private class ScoreboardQuickUpdate
    extends BukkitRunnable {
        private ScoreboardQuickUpdate() {
        }

        public void run() {
            ScoreboardWrapper.this.updateSidebar();
            ScoreboardWrapper.this.updateTask = null;
        }
    }
}

