/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.scoreboards;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.database.PlayerStat;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SuperAbilityType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.scoreboards.ScoreboardWrapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;

public class ScoreboardManager {
    static final Map<String, ScoreboardWrapper> PLAYER_SCOREBOARDS = new HashMap<String, ScoreboardWrapper>();
    static final String SIDEBAR_OBJECTIVE = "mcmmo_sidebar";
    static final String POWER_OBJECTIVE = "mcmmo_pwrlvl";
    static final String HEADER_STATS = LocaleLoader.getString("Scoreboard.Header.PlayerStats");
    static final String HEADER_COOLDOWNS = LocaleLoader.getString("Scoreboard.Header.PlayerCooldowns");
    static final String HEADER_RANK = LocaleLoader.getString("Scoreboard.Header.PlayerRank");
    static final String TAG_POWER_LEVEL = LocaleLoader.getString("Scoreboard.Header.PowerLevel");
    static final String POWER_LEVEL;
    static final String LABEL_POWER_LEVEL;
    static final String LABEL_LEVEL;
    static final String LABEL_CURRENT_XP;
    static final String LABEL_REMAINING_XP;
    static final String LABEL_ABILITY_COOLDOWN;
    static final String LABEL_OVERALL;
    static final Map<PrimarySkillType, String> skillLabels;
    static final Map<SuperAbilityType, String> abilityLabelsColored;
    static final Map<SuperAbilityType, String> abilityLabelsSkill;
    private static List<String> dirtyPowerLevels;

    private static String formatAbility(String string) {
        return ScoreboardManager.formatAbility(ChatColor.AQUA, string);
    }

    private static String formatAbility(ChatColor chatColor, String string) {
        if (Config.getInstance().getShowAbilityNames()) {
            return ScoreboardManager.getShortenedName(chatColor + string);
        }
        return chatColor + LocaleLoader.getString("Scoreboard.Misc.Ability");
    }

    private static String getShortenedName(String string) {
        return ScoreboardManager.getShortenedName(string, true);
    }

    private static String getShortenedName(String string, boolean bl) {
        if (string.length() > 16) {
            string = bl ? string.substring(0, 14) + ".." : string.substring(0, 16);
        }
        return string;
    }

    public static void setupPlayer(Player player) {
        PLAYER_SCOREBOARDS.put(player.getName(), ScoreboardWrapper.create(player));
        dirtyPowerLevels.add(player.getName());
    }

    public static void teardownPlayer(Player player) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.remove(player.getName());
        if (scoreboardWrapper != null && scoreboardWrapper.revertTask != null) {
            scoreboardWrapper.revertTask.cancel();
        }
    }

    public static void teardownAll() {
        ImmutableList immutableList = ImmutableList.copyOf((Collection)mcMMO.p.getServer().getOnlinePlayers());
        mcMMO.p.debug("Tearing down scoreboards... (" + immutableList.size() + ")");
        for (Player player : immutableList) {
            ScoreboardManager.teardownPlayer(player);
        }
    }

    public static void cleanup(ScoreboardWrapper scoreboardWrapper) {
        PLAYER_SCOREBOARDS.remove(scoreboardWrapper.playerName);
        if (scoreboardWrapper.revertTask != null) {
            scoreboardWrapper.revertTask.cancel();
        }
    }

    public static void handleLevelUp(Player player, PrimarySkillType primarySkillType) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        if (scoreboardWrapper.isSkillScoreboard() && scoreboardWrapper.targetSkill == primarySkillType || scoreboardWrapper.isStatsScoreboard() && scoreboardWrapper.isBoardShown()) {
            scoreboardWrapper.doSidebarUpdateSoon();
        }
        String string = player.getName();
        for (ScoreboardWrapper scoreboardWrapper2 : PLAYER_SCOREBOARDS.values()) {
            if (!scoreboardWrapper2.isStatsScoreboard() || !string.equals(scoreboardWrapper2.targetPlayer) || !scoreboardWrapper.isBoardShown()) continue;
            scoreboardWrapper.doSidebarUpdateSoon();
        }
        if (Config.getInstance().getPowerLevelTagsEnabled() && !dirtyPowerLevels.contains(string)) {
            dirtyPowerLevels.add(string);
        }
        if (Config.getInstance().getSkillLevelUpBoard()) {
            ScoreboardManager.enablePlayerSkillLevelUpScoreboard(player, primarySkillType);
        }
    }

    public static void handleXp(Player player, PrimarySkillType primarySkillType) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        if (scoreboardWrapper != null && scoreboardWrapper.isSkillScoreboard() && scoreboardWrapper.targetSkill == primarySkillType && scoreboardWrapper.isBoardShown()) {
            scoreboardWrapper.doSidebarUpdateSoon();
        }
    }

    public static void cooldownUpdate(Player player, PrimarySkillType primarySkillType) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        if (scoreboardWrapper != null && (scoreboardWrapper.isCooldownScoreboard() || scoreboardWrapper.isSkillScoreboard() && scoreboardWrapper.targetSkill == primarySkillType) && scoreboardWrapper.isBoardShown()) {
            scoreboardWrapper.doSidebarUpdateSoon();
        }
    }

    public static void enablePlayerSkillScoreboard(Player player, PrimarySkillType primarySkillType) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeSkill(primarySkillType);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getSkillScoreboardTime());
    }

    public static void enablePlayerSkillLevelUpScoreboard(Player player, PrimarySkillType primarySkillType) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        if (scoreboardWrapper.isBoardShown()) {
            return;
        }
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeSkill(primarySkillType);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getSkillLevelUpTime());
    }

    public static void enablePlayerStatsScoreboard(Player player) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeSelfStats();
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getStatsScoreboardTime());
    }

    public static void enablePlayerInspectScoreboard(Player player, PlayerProfile playerProfile) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeInspectStats(playerProfile);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getInspectScoreboardTime());
    }

    public static void enablePlayerCooldownScoreboard(Player player) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeCooldowns();
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getCooldownScoreboardTime());
    }

    public static void showPlayerRankScoreboard(Player player, Map<PrimarySkillType, Integer> map) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeSelfRank();
        scoreboardWrapper.acceptRankData(map);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getRankScoreboardTime());
    }

    public static void showPlayerRankScoreboardOthers(Player player, String string, Map<PrimarySkillType, Integer> map) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeInspectRank(string);
        scoreboardWrapper.acceptRankData(map);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getRankScoreboardTime());
    }

    public static void showTopScoreboard(Player player, PrimarySkillType primarySkillType, int n, List<PlayerStat> list) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeTop(primarySkillType, n);
        scoreboardWrapper.acceptLeaderboardData(list);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getTopScoreboardTime());
    }

    public static void showTopPowerScoreboard(Player player, int n, List<PlayerStat> list) {
        ScoreboardWrapper scoreboardWrapper = PLAYER_SCOREBOARDS.get(player.getName());
        scoreboardWrapper.setOldScoreboard();
        scoreboardWrapper.setTypeTopPower(n);
        scoreboardWrapper.acceptLeaderboardData(list);
        ScoreboardManager.changeScoreboard(scoreboardWrapper, Config.getInstance().getTopScoreboardTime());
    }

    public static boolean powerLevelHeartbeat() {
        Objective objective = ScoreboardManager.getPowerLevelObjective();
        if (objective == null) {
            return false;
        }
        for (String string : dirtyPowerLevels) {
            McMMOPlayer mcMMOPlayer = UserManager.getPlayer(string);
            if (mcMMOPlayer == null) continue;
            Player player = mcMMOPlayer.getPlayer();
            int n = mcMMOPlayer.getPowerLevel();
            objective.getScore(string).setScore(n);
            for (ScoreboardWrapper scoreboardWrapper : PLAYER_SCOREBOARDS.values()) {
                scoreboardWrapper.updatePowerLevel(player, n);
            }
        }
        dirtyPowerLevels.clear();
        return true;
    }

    public static Objective getPowerLevelObjective() {
        if (!Config.getInstance().getPowerLevelTagsEnabled()) {
            Objective objective = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard().getObjective(POWER_OBJECTIVE);
            if (objective != null) {
                objective.unregister();
                mcMMO.p.debug("Removed leftover targetBoard objects from Power Level Tags.");
            }
            return null;
        }
        Objective objective = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard().getObjective(POWER_OBJECTIVE);
        if (objective == null) {
            objective = mcMMO.p.getServer().getScoreboardManager().getMainScoreboard().registerNewObjective(POWER_OBJECTIVE, "dummy");
            objective.setDisplayName(TAG_POWER_LEVEL);
            objective.setDisplaySlot(DisplaySlot.BELOW_NAME);
        }
        return objective;
    }

    private static void changeScoreboard(ScoreboardWrapper scoreboardWrapper, int n) {
        if (n == -1) {
            scoreboardWrapper.showBoardWithNoRevert();
        } else {
            scoreboardWrapper.showBoardAndScheduleRevert(n * 20);
        }
    }

    public static boolean isBoardShown(String string) {
        return PLAYER_SCOREBOARDS.get(string).isBoardShown();
    }

    public static void clearBoard(String string) {
        PLAYER_SCOREBOARDS.get(string).tryRevertBoard();
    }

    public static void keepBoard(String string) {
        PLAYER_SCOREBOARDS.get(string).cancelRevert();
    }

    public static void setRevertTimer(String string, int n) {
        PLAYER_SCOREBOARDS.get(string).showBoardAndScheduleRevert(n * 20);
    }

    static {
        LABEL_POWER_LEVEL = POWER_LEVEL = LocaleLoader.getString("Scoreboard.Misc.PowerLevel");
        LABEL_LEVEL = LocaleLoader.getString("Scoreboard.Misc.Level");
        LABEL_CURRENT_XP = LocaleLoader.getString("Scoreboard.Misc.CurrentXP");
        LABEL_REMAINING_XP = LocaleLoader.getString("Scoreboard.Misc.RemainingXP");
        LABEL_ABILITY_COOLDOWN = LocaleLoader.getString("Scoreboard.Misc.Cooldown");
        LABEL_OVERALL = LocaleLoader.getString("Scoreboard.Misc.Overall");
        ImmutableMap.Builder builder = ImmutableMap.builder();
        ImmutableMap.Builder builder2 = ImmutableMap.builder();
        ImmutableMap.Builder builder3 = ImmutableMap.builder();
        if (Config.getInstance().getScoreboardRainbows()) {
            ArrayList arrayList = Lists.newArrayList((Object[])new ChatColor[]{ChatColor.WHITE, ChatColor.YELLOW, ChatColor.LIGHT_PURPLE, ChatColor.RED, ChatColor.AQUA, ChatColor.GREEN, ChatColor.DARK_GRAY, ChatColor.BLUE, ChatColor.DARK_PURPLE, ChatColor.DARK_RED, ChatColor.DARK_AQUA, ChatColor.DARK_GREEN, ChatColor.DARK_BLUE});
            Collections.shuffle(arrayList, Misc.getRandom());
            int n = 0;
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                builder.put((Object)primarySkillType, (Object)ScoreboardManager.getShortenedName(arrayList.get(n) + primarySkillType.getName(), false));
                if (primarySkillType.getAbility() != null) {
                    builder2.put((Object)primarySkillType.getAbility(), (Object)ScoreboardManager.getShortenedName(arrayList.get(n) + primarySkillType.getAbility().getName()));
                    if (primarySkillType == PrimarySkillType.MINING) {
                        builder2.put((Object)SuperAbilityType.BLAST_MINING, (Object)ScoreboardManager.getShortenedName(arrayList.get(n) + SuperAbilityType.BLAST_MINING.getName()));
                    }
                }
                if (++n != arrayList.size()) continue;
                n = 0;
            }
        } else {
            for (PrimarySkillType primarySkillType : PrimarySkillType.values()) {
                builder.put((Object)primarySkillType, (Object)ScoreboardManager.getShortenedName(ChatColor.GREEN + primarySkillType.getName()));
                if (primarySkillType.getAbility() == null) continue;
                builder2.put((Object)primarySkillType.getAbility(), (Object)ScoreboardManager.formatAbility(primarySkillType.getAbility().getName()));
                if (primarySkillType != PrimarySkillType.MINING) continue;
                builder2.put((Object)SuperAbilityType.BLAST_MINING, (Object)ScoreboardManager.formatAbility(SuperAbilityType.BLAST_MINING.getName()));
            }
        }
        for (Enum enum_ : SuperAbilityType.values()) {
            builder3.put((Object)enum_, (Object)ScoreboardManager.formatAbility(enum_ == SuperAbilityType.BLAST_MINING ? ChatColor.BLUE : ChatColor.AQUA, ((SuperAbilityType)enum_).getName()));
        }
        skillLabels = builder.build();
        abilityLabelsColored = builder2.build();
        abilityLabelsSkill = builder3.build();
        dirtyPowerLevels = new ArrayList<String>();
    }

    public static enum SidebarType {
        NONE,
        SKILL_BOARD,
        STATS_BOARD,
        COOLDOWNS_BOARD,
        RANK_BOARD,
        TOP_BOARD;

    }
}

