/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.random;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.datatypes.skills.subskills.AbstractSubSkill;
import com.gmail.nossr50.events.skills.secondaryabilities.SubSkillEvent;
import com.gmail.nossr50.events.skills.secondaryabilities.SubSkillRandomCheckEvent;
import com.gmail.nossr50.util.EventUtils;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.random.InvalidStaticChance;
import com.gmail.nossr50.util.random.RandomChanceExecution;
import com.gmail.nossr50.util.random.RandomChanceSkill;
import com.gmail.nossr50.util.random.RandomChanceSkillStatic;
import com.gmail.nossr50.util.random.RandomChanceStatic;
import com.gmail.nossr50.util.skills.SkillActivationType;
import java.text.DecimalFormat;
import java.util.Random;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class RandomChanceUtil {
    public static final DecimalFormat percent = new DecimalFormat("##0.00%");
    public static final double LINEAR_CURVE_VAR = 100.0;

    public static boolean isActivationSuccessful(SkillActivationType skillActivationType, SubSkillType subSkillType, Player player) {
        switch (skillActivationType) {
            case RANDOM_LINEAR_100_SCALE_WITH_CAP: {
                return RandomChanceUtil.checkRandomChanceExecutionSuccess(player, subSkillType, true);
            }
            case RANDOM_STATIC_CHANCE: {
                return RandomChanceUtil.checkRandomStaticChanceExecutionSuccess(player, subSkillType);
            }
            case ALWAYS_FIRES: {
                SubSkillEvent subSkillEvent = EventUtils.callSubSkillEvent(player, subSkillType);
                return !subSkillEvent.isCancelled();
            }
        }
        return false;
    }

    public static double getActivationChance(SkillActivationType skillActivationType, SubSkillType subSkillType, Player player) {
        switch (skillActivationType) {
            case RANDOM_LINEAR_100_SCALE_WITH_CAP: {
                return RandomChanceUtil.getRandomChanceExecutionSuccess(player, subSkillType, true);
            }
            case RANDOM_STATIC_CHANCE: {
                return RandomChanceUtil.getRandomStaticChanceExecutionSuccess(player, subSkillType);
            }
        }
        return 0.1337;
    }

    public static boolean checkRandomChanceExecutionSuccess(Player player, PrimarySkillType primarySkillType, double d) {
        d *= 100.0;
        d = RandomChanceUtil.addLuck(player, primarySkillType, d);
        return RandomChanceUtil.rollDice(d, 10000);
    }

    public static boolean rollDice(double d, int n) {
        Random random = new Random();
        return d > (double)random.nextInt(n);
    }

    public static boolean checkRandomChanceExecutionSuccess(RandomChanceSkillStatic randomChanceSkillStatic) {
        double d = RandomChanceUtil.calculateChanceOfSuccess(randomChanceSkillStatic);
        return RandomChanceUtil.rollDice(d, 100);
    }

    public static boolean checkRandomChanceExecutionSuccess(RandomChanceSkill randomChanceSkill) {
        double d = RandomChanceUtil.calculateChanceOfSuccess(randomChanceSkill);
        Random random = new Random();
        return RandomChanceUtil.rollDice(d, 100);
    }

    public static double getRandomChanceExecutionChance(RandomChanceExecution randomChanceExecution) {
        double d = RandomChanceUtil.getChanceOfSuccess(randomChanceExecution.getXPos(), randomChanceExecution.getProbabilityCap(), 100.0);
        return d;
    }

    public static double getRandomChanceExecutionChance(RandomChanceStatic randomChanceStatic) {
        double d = RandomChanceUtil.getChanceOfSuccess(randomChanceStatic.getXPos(), randomChanceStatic.getProbabilityCap(), 100.0);
        d = RandomChanceUtil.addLuck(randomChanceStatic.isLucky(), d);
        return d;
    }

    private static double calculateChanceOfSuccess(RandomChanceSkill randomChanceSkill) {
        double d = randomChanceSkill.getSkillLevel();
        double d2 = randomChanceSkill.getProbabilityCap();
        double d3 = randomChanceSkill.getMaximumBonusLevelCap();
        double d4 = d >= d3 ? d2 : (double)RandomChanceUtil.getChanceOfSuccess(randomChanceSkill.getXPos(), d2, d3);
        d4 = RandomChanceUtil.addLuck(randomChanceSkill.isLucky(), d4);
        return d4;
    }

    private static double calculateChanceOfSuccess(RandomChanceSkillStatic randomChanceSkillStatic) {
        double d = RandomChanceUtil.getChanceOfSuccess(randomChanceSkillStatic.getXPos(), 100.0, 100.0);
        d = RandomChanceUtil.addLuck(randomChanceSkillStatic.isLucky(), d);
        return d;
    }

    private static int getChanceOfSuccess(double d, double d2, double d3) {
        return (int)(d2 * (d / d3));
    }

    private static int getChanceOfSuccess(double d, double d2) {
        return (int)(d / (d2 / 100.0));
    }

    public static double getRandomChanceExecutionSuccess(Player player, SubSkillType subSkillType, boolean bl) {
        RandomChanceSkill randomChanceSkill = new RandomChanceSkill(player, subSkillType, bl);
        return RandomChanceUtil.calculateChanceOfSuccess(randomChanceSkill);
    }

    public static double getRandomStaticChanceExecutionSuccess(Player player, SubSkillType subSkillType) {
        try {
            return RandomChanceUtil.getRandomChanceExecutionChance(new RandomChanceSkillStatic(RandomChanceUtil.getStaticRandomChance(subSkillType), player, subSkillType));
        }
        catch (InvalidStaticChance invalidStaticChance) {
            invalidStaticChance.printStackTrace();
            return 0.1337;
        }
    }

    public static boolean checkRandomChanceExecutionSuccess(Player player, SubSkillType subSkillType, boolean bl) {
        return RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkill(player, subSkillType, bl));
    }

    public static boolean checkRandomChanceExecutionSuccess(Player player, SubSkillType subSkillType) {
        return RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkill(player, subSkillType));
    }

    public static boolean checkRandomStaticChanceExecutionSuccess(Player player, SubSkillType subSkillType) {
        try {
            return RandomChanceUtil.checkRandomChanceExecutionSuccess(new RandomChanceSkillStatic(RandomChanceUtil.getStaticRandomChance(subSkillType), player, subSkillType));
        }
        catch (InvalidStaticChance invalidStaticChance) {
            invalidStaticChance.printStackTrace();
            return false;
        }
    }

    public static double getStaticRandomChance(SubSkillType subSkillType) {
        switch (subSkillType) {
            case AXES_ARMOR_IMPACT: {
                return AdvancedConfig.getInstance().getImpactChance();
            }
            case AXES_GREATER_IMPACT: {
                return AdvancedConfig.getInstance().getGreaterImpactChance();
            }
            case TAMING_FAST_FOOD_SERVICE: {
                return AdvancedConfig.getInstance().getFastFoodChance();
            }
        }
        throw new InvalidStaticChance();
    }

    public static boolean sendSkillEvent(Player player, SubSkillType subSkillType, double d) {
        SubSkillRandomCheckEvent subSkillRandomCheckEvent = new SubSkillRandomCheckEvent(player, subSkillType, d);
        return !subSkillRandomCheckEvent.isCancelled();
    }

    public static boolean isActivationSuccessful(SkillActivationType skillActivationType, AbstractSubSkill abstractSubSkill, Player player) {
        return RandomChanceUtil.isActivationSuccessful(skillActivationType, abstractSubSkill.getSubSkillType(), player);
    }

    public static String[] calculateAbilityDisplayValues(SkillActivationType skillActivationType, Player player, SubSkillType subSkillType) {
        double d = RandomChanceUtil.getActivationChance(skillActivationType, subSkillType, player);
        String[] stringArray = new String[2];
        boolean bl = Permissions.lucky((Permissible)player, subSkillType.getParentSkill());
        stringArray[0] = percent.format(Math.min(d, 100.0) / 100.0);
        stringArray[1] = bl ? percent.format(Math.min(d * 1.3333, 100.0) / 100.0) : null;
        return stringArray;
    }

    public static String[] calculateAbilityDisplayValuesStatic(Player player, PrimarySkillType primarySkillType, double d) {
        RandomChanceStatic randomChanceStatic = new RandomChanceStatic(d, false);
        double d2 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceStatic);
        RandomChanceStatic randomChanceStatic2 = new RandomChanceStatic(d, true);
        double d3 = RandomChanceUtil.getRandomChanceExecutionChance(randomChanceStatic2);
        String[] stringArray = new String[2];
        boolean bl = Permissions.lucky((Permissible)player, primarySkillType);
        stringArray[0] = percent.format(Math.min(d2, 100.0) / 100.0);
        stringArray[1] = bl ? percent.format(Math.min(d3, 100.0) / 100.0) : null;
        return stringArray;
    }

    public static String[] calculateAbilityDisplayValuesCustom(SkillActivationType skillActivationType, Player player, SubSkillType subSkillType, double d) {
        double d2 = RandomChanceUtil.getActivationChance(skillActivationType, subSkillType, player);
        String[] stringArray = new String[2];
        boolean bl = Permissions.lucky((Permissible)player, subSkillType.getParentSkill());
        stringArray[0] = percent.format(Math.min(d2 *= d, 100.0) / 100.0);
        stringArray[1] = bl ? percent.format(Math.min(d2 * 1.3333, 100.0) / 100.0) : null;
        return stringArray;
    }

    public static double addLuck(Player player, PrimarySkillType primarySkillType, double d) {
        if (Permissions.lucky((Permissible)player, primarySkillType)) {
            return d * 1.333;
        }
        return d;
    }

    public static double addLuck(boolean bl, double d) {
        if (bl) {
            return d * 1.333;
        }
        return d;
    }
}

