/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.random;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.random.RandomChanceExecution;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;

public class RandomChanceSkill
implements RandomChanceExecution {
    protected final PrimarySkillType primarySkillType;
    protected final SubSkillType subSkillType;
    protected final double probabilityCap;
    protected final boolean isLucky;
    private int skillLevel;

    public RandomChanceSkill(Player player, SubSkillType subSkillType) {
        this.primarySkillType = subSkillType.getParentSkill();
        this.subSkillType = subSkillType;
        this.probabilityCap = 100.0;
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        this.skillLevel = player != null && mcMMOPlayer != null ? mcMMOPlayer.getSkillLevel(this.primarySkillType) : 0;
        this.isLucky = player != null ? Permissions.lucky((Permissible)player, this.primarySkillType) : false;
    }

    public RandomChanceSkill(Player player, SubSkillType subSkillType, boolean bl) {
        this.probabilityCap = bl ? AdvancedConfig.getInstance().getMaximumProbability(subSkillType) : 100.0;
        this.primarySkillType = subSkillType.getParentSkill();
        this.subSkillType = subSkillType;
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        this.skillLevel = player != null && mcMMOPlayer != null ? mcMMOPlayer.getSkillLevel(this.primarySkillType) : 0;
        this.isLucky = player != null ? Permissions.lucky((Permissible)player, this.primarySkillType) : false;
    }

    public SubSkillType getSubSkill() {
        return this.subSkillType;
    }

    public int getSkillLevel() {
        return this.skillLevel;
    }

    public void setSkillLevel(int n) {
        this.skillLevel = n;
    }

    public double getMaximumBonusLevelCap() {
        return AdvancedConfig.getInstance().getMaxBonusLevel(this.subSkillType);
    }

    @Override
    public double getXPos() {
        return this.getSkillLevel();
    }

    @Override
    public double getProbabilityCap() {
        return this.probabilityCap;
    }

    public boolean isLucky() {
        return this.isLucky;
    }
}

