/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.player;

import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.mcMMO;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public final class UserManager {
    private static HashSet<McMMOPlayer> playerDataSet;

    private UserManager() {
    }

    public static void track(McMMOPlayer mcMMOPlayer) {
        mcMMOPlayer.getPlayer().setMetadata("mcMMO: Player Data", (MetadataValue)new FixedMetadataValue((Plugin)mcMMO.p, (Object)mcMMOPlayer));
        if (playerDataSet == null) {
            playerDataSet = new HashSet();
        }
        playerDataSet.add(mcMMOPlayer);
    }

    public static void cleanupPlayer(McMMOPlayer mcMMOPlayer) {
        if (playerDataSet != null && playerDataSet.contains(mcMMOPlayer)) {
            playerDataSet.remove(mcMMOPlayer);
        }
    }

    public static void remove(Player player) {
        McMMOPlayer mcMMOPlayer = UserManager.getPlayer(player);
        mcMMOPlayer.cleanup();
        player.removeMetadata("mcMMO: Player Data", (Plugin)mcMMO.p);
        if (playerDataSet != null && playerDataSet.contains(mcMMOPlayer)) {
            playerDataSet.remove(mcMMOPlayer);
        }
    }

    public static void clearAll() {
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            UserManager.remove(player);
        }
        if (playerDataSet != null) {
            playerDataSet.clear();
        }
    }

    public static void saveAll() {
        if (playerDataSet == null) {
            return;
        }
        ImmutableList immutableList = ImmutableList.copyOf(playerDataSet);
        mcMMO.p.getLogger().info("Saving mcMMOPlayers... (" + immutableList.size() + ")");
        for (McMMOPlayer mcMMOPlayer : immutableList) {
            try {
                mcMMO.p.getLogger().info("Saving data for player: " + mcMMOPlayer.getPlayerName());
                mcMMOPlayer.getProfile().save(true);
            }
            catch (Exception exception) {
                mcMMO.p.getLogger().warning("Could not save mcMMO player data for player: " + mcMMOPlayer.getPlayerName());
            }
        }
        mcMMO.p.getLogger().info("Finished save operation for " + immutableList.size() + " players!");
    }

    public static Collection<McMMOPlayer> getPlayers() {
        ArrayList<McMMOPlayer> arrayList = new ArrayList<McMMOPlayer>();
        for (Player player : mcMMO.p.getServer().getOnlinePlayers()) {
            if (!UserManager.hasPlayerDataKey((Entity)player)) continue;
            arrayList.add(UserManager.getPlayer(player));
        }
        return arrayList;
    }

    public static McMMOPlayer getPlayer(String string) {
        return UserManager.retrieveMcMMOPlayer(string, false);
    }

    public static McMMOPlayer getOfflinePlayer(OfflinePlayer offlinePlayer) {
        if (offlinePlayer instanceof Player) {
            return UserManager.getPlayer((Player)offlinePlayer);
        }
        return UserManager.retrieveMcMMOPlayer(offlinePlayer.getName(), true);
    }

    public static McMMOPlayer getOfflinePlayer(String string) {
        return UserManager.retrieveMcMMOPlayer(string, true);
    }

    public static McMMOPlayer getPlayer(Player player) {
        if (player != null && player.hasMetadata("mcMMO: Player Data")) {
            return (McMMOPlayer)((MetadataValue)player.getMetadata("mcMMO: Player Data").get(0)).value();
        }
        return null;
    }

    private static McMMOPlayer retrieveMcMMOPlayer(String string, boolean bl) {
        Player player = mcMMO.p.getServer().getPlayerExact(string);
        if (player == null) {
            if (!bl) {
                mcMMO.p.getLogger().warning("A valid mcMMOPlayer object could not be found for " + string + ".");
            }
            return null;
        }
        return UserManager.getPlayer(player);
    }

    public static boolean hasPlayerDataKey(Entity entity) {
        return entity != null && entity.hasMetadata("mcMMO: Player Data");
    }
}

