/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.player;

import com.gmail.nossr50.config.AdvancedConfig;
import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.interactions.NotificationType;
import com.gmail.nossr50.datatypes.notifications.SensitiveCommandType;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.datatypes.skills.SubSkillType;
import com.gmail.nossr50.events.skills.McMMOPlayerNotificationEvent;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Permissions;
import com.gmail.nossr50.util.TextComponentFactory;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.sounds.SoundManager;
import com.gmail.nossr50.util.sounds.SoundType;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Server;
import org.bukkit.SoundCategory;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.permissions.Permissible;

public class NotificationManager {
    public static void sendPlayerInformation(Player player, NotificationType notificationType, String string) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        ChatMessageType chatMessageType = AdvancedConfig.getInstance().doesNotificationUseActionBar(notificationType) ? ChatMessageType.ACTION_BAR : ChatMessageType.SYSTEM;
        TextComponent textComponent = TextComponentFactory.getNotificationTextComponentFromLocale(string);
        McMMOPlayerNotificationEvent mcMMOPlayerNotificationEvent = NotificationManager.checkNotificationEvent(player, notificationType, chatMessageType, textComponent);
        NotificationManager.sendNotification(player, mcMMOPlayerNotificationEvent);
    }

    public static boolean doesPlayerUseNotifications(Player player) {
        if (UserManager.getPlayer(player) == null) {
            return false;
        }
        return UserManager.getPlayer(player).useChatNotifications();
    }

    public static void sendNearbyPlayersInformation(Player player, NotificationType notificationType, String string, String ... stringArray) {
        NotificationManager.sendPlayerInformation(player, notificationType, string, stringArray);
    }

    public static void sendPlayerInformationChatOnly(Player player, String string, String ... stringArray) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        String string2 = LocaleLoader.getString(string, stringArray);
        player.sendMessage(string2);
    }

    public static void sendPlayerInformationChatOnlyPrefixed(Player player, String string, String ... stringArray) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        String string2 = LocaleLoader.getString(string, stringArray);
        String string3 = LocaleLoader.getString("mcMMO.Template.Prefix", string2);
        player.sendMessage(string3);
    }

    public static void sendPlayerInformation(Player player, NotificationType notificationType, String string, String ... stringArray) {
        if (UserManager.getPlayer(player) == null || !UserManager.getPlayer(player).useChatNotifications()) {
            return;
        }
        ChatMessageType chatMessageType = AdvancedConfig.getInstance().doesNotificationUseActionBar(notificationType) ? ChatMessageType.ACTION_BAR : ChatMessageType.SYSTEM;
        TextComponent textComponent = TextComponentFactory.getNotificationMultipleValues(string, stringArray);
        McMMOPlayerNotificationEvent mcMMOPlayerNotificationEvent = NotificationManager.checkNotificationEvent(player, notificationType, chatMessageType, textComponent);
        NotificationManager.sendNotification(player, mcMMOPlayerNotificationEvent);
    }

    private static void sendNotification(Player player, McMMOPlayerNotificationEvent mcMMOPlayerNotificationEvent) {
        if (mcMMOPlayerNotificationEvent.isCancelled()) {
            return;
        }
        if (mcMMOPlayerNotificationEvent.getChatMessageType() == ChatMessageType.ACTION_BAR) {
            player.spigot().sendMessage(mcMMOPlayerNotificationEvent.getChatMessageType(), (BaseComponent)mcMMOPlayerNotificationEvent.getNotificationTextComponent());
            if (mcMMOPlayerNotificationEvent.isMessageAlsoBeingSentToChat()) {
                player.spigot().sendMessage(ChatMessageType.SYSTEM, (BaseComponent)mcMMOPlayerNotificationEvent.getNotificationTextComponent());
            }
        } else {
            player.spigot().sendMessage(mcMMOPlayerNotificationEvent.getChatMessageType(), (BaseComponent)mcMMOPlayerNotificationEvent.getNotificationTextComponent());
        }
    }

    private static McMMOPlayerNotificationEvent checkNotificationEvent(Player player, NotificationType notificationType, ChatMessageType chatMessageType, TextComponent textComponent) {
        McMMOPlayerNotificationEvent mcMMOPlayerNotificationEvent = new McMMOPlayerNotificationEvent(player, notificationType, textComponent, chatMessageType, AdvancedConfig.getInstance().doesNotificationSendCopyToChat(notificationType));
        Bukkit.getServer().getPluginManager().callEvent((Event)mcMMOPlayerNotificationEvent);
        return mcMMOPlayerNotificationEvent;
    }

    public static void sendPlayerLevelUpNotification(McMMOPlayer mcMMOPlayer, PrimarySkillType primarySkillType, int n, int n2) {
        if (!mcMMOPlayer.useChatNotifications()) {
            return;
        }
        ChatMessageType chatMessageType = AdvancedConfig.getInstance().doesNotificationUseActionBar(NotificationType.LEVEL_UP_MESSAGE) ? ChatMessageType.ACTION_BAR : ChatMessageType.SYSTEM;
        TextComponent textComponent = TextComponentFactory.getNotificationLevelUpTextComponent(primarySkillType, n, n2);
        McMMOPlayerNotificationEvent mcMMOPlayerNotificationEvent = NotificationManager.checkNotificationEvent(mcMMOPlayer.getPlayer(), NotificationType.LEVEL_UP_MESSAGE, chatMessageType, textComponent);
        NotificationManager.sendNotification(mcMMOPlayer.getPlayer(), mcMMOPlayerNotificationEvent);
    }

    public static void broadcastTitle(Server server, String string, String string2, int n, int n2, int n3) {
        for (Player player : server.getOnlinePlayers()) {
            player.sendTitle(string, string2, n, n2, n3);
        }
    }

    public static void sendPlayerUnlockNotification(McMMOPlayer mcMMOPlayer, SubSkillType subSkillType) {
        if (!mcMMOPlayer.useChatNotifications()) {
            return;
        }
        mcMMOPlayer.getPlayer().spigot().sendMessage((BaseComponent)TextComponentFactory.getSubSkillUnlockedNotificationComponents(mcMMOPlayer.getPlayer(), subSkillType));
        SoundManager.sendCategorizedSound(mcMMOPlayer.getPlayer(), mcMMOPlayer.getPlayer().getLocation(), SoundType.SKILL_UNLOCKED, SoundCategory.MASTER);
    }

    private static void sendAdminNotification(String string) {
        if (!Config.getInstance().adminNotifications()) {
            return;
        }
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            if (!player.isOp() && !Permissions.adminChat((Permissible)player)) continue;
            player.sendMessage(LocaleLoader.getString("Notifications.Admin.Format.Others", string));
        }
        mcMMO.p.getLogger().info(LocaleLoader.getString("Notifications.Admin.Format.Others", string));
    }

    private static void sendAdminCommandConfirmation(CommandSender commandSender, String string) {
        commandSender.sendMessage(LocaleLoader.getString("Notifications.Admin.Format.Self", string));
    }

    public static void processSensitiveCommandNotification(CommandSender commandSender, SensitiveCommandType sensitiveCommandType, String ... stringArray) {
        String string = LocaleLoader.getString("Server.ConsoleName");
        if (commandSender instanceof Player) {
            string = ((Player)commandSender).getDisplayName() + ChatColor.RESET + "-" + ((Player)commandSender).getUniqueId();
        }
        switch (sensitiveCommandType) {
            case XPRATE_MODIFY: {
                NotificationManager.sendAdminNotification(LocaleLoader.getString("Notifications.Admin.XPRate.Start.Others", NotificationManager.addItemToFirstPositionOfArray(string, stringArray)));
                NotificationManager.sendAdminCommandConfirmation(commandSender, LocaleLoader.getString("Notifications.Admin.XPRate.Start.Self", stringArray));
                break;
            }
            case XPRATE_END: {
                NotificationManager.sendAdminNotification(LocaleLoader.getString("Notifications.Admin.XPRate.End.Others", NotificationManager.addItemToFirstPositionOfArray(string, stringArray)));
                NotificationManager.sendAdminCommandConfirmation(commandSender, LocaleLoader.getString("Notifications.Admin.XPRate.End.Self", stringArray));
            }
        }
    }

    public static String[] addItemToFirstPositionOfArray(String string, String ... stringArray) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
        return stringArray2;
    }
}

