/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.experience.FormulaType;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.mcMMO;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.YamlConfiguration;

public class FormulaManager {
    private static File formulaFile = new File(mcMMO.getFlatFileDirectory() + "formula.yml");
    private Map<Integer, Integer> experienceNeededRetroLinear;
    private Map<Integer, Integer> experienceNeededStandardLinear;
    private Map<Integer, Integer> experienceNeededRetroExponential;
    private Map<Integer, Integer> experienceNeededStandardExponential;
    private FormulaType previousFormula;

    public FormulaManager() {
        this.initExperienceNeededMaps();
        this.loadFormula();
    }

    private void initExperienceNeededMaps() {
        this.experienceNeededRetroLinear = new HashMap<Integer, Integer>();
        this.experienceNeededRetroExponential = new HashMap<Integer, Integer>();
        this.experienceNeededStandardLinear = new HashMap<Integer, Integer>();
        this.experienceNeededStandardExponential = new HashMap<Integer, Integer>();
    }

    public FormulaType getPreviousFormulaType() {
        return this.previousFormula;
    }

    public void setPreviousFormulaType(FormulaType formulaType) {
        this.previousFormula = formulaType;
    }

    public int calculateTotalExperience(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            n3 += this.getXPtoNextLevel(i, this.previousFormula);
        }
        return n3 += n2;
    }

    public int[] calculateNewLevel(PrimarySkillType primarySkillType, int n, FormulaType formulaType) {
        int n2;
        int n3;
        int n4 = 0;
        int n5 = Config.getInstance().getLevelCap(primarySkillType);
        for (n3 = 0; n > 0 && n3 < n5; ++n3, n -= n2) {
            n2 = this.getXPtoNextLevel(n3, formulaType);
            if (n - n2 >= 0) continue;
            n4 = n;
            break;
        }
        return new int[]{n3, n4};
    }

    public int getXPtoNextLevel(int n, FormulaType formulaType) {
        if (formulaType == FormulaType.UNKNOWN) {
            formulaType = FormulaType.LINEAR;
        }
        return this.processXPToNextLevel(n, formulaType);
    }

    private int processXPToNextLevel(int n, FormulaType formulaType) {
        if (mcMMO.isRetroModeEnabled()) {
            return this.processXPRetroToNextLevel(n, formulaType);
        }
        return this.processStandardXPToNextLevel(n, formulaType);
    }

    private int processStandardXPToNextLevel(int n, FormulaType formulaType) {
        Map<Integer, Integer> map;
        Map<Integer, Integer> map2 = map = formulaType == FormulaType.LINEAR ? this.experienceNeededStandardLinear : this.experienceNeededStandardExponential;
        if (!map.containsKey(n)) {
            int n2;
            int n3 = 0;
            for (int i = n2 = n * 10 + 1; i < n2 + 10; ++i) {
                n3 += this.calculateXPNeeded(i, formulaType);
            }
            map.put(n, n3);
        }
        return map.get(n);
    }

    private int processXPRetroToNextLevel(int n, FormulaType formulaType) {
        Map<Integer, Integer> map;
        Map<Integer, Integer> map2 = map = formulaType == FormulaType.LINEAR ? this.experienceNeededRetroLinear : this.experienceNeededRetroExponential;
        if (!map.containsKey(n)) {
            int n2 = this.calculateXPNeeded(n, formulaType);
            map.put(n, n2);
        }
        return map.get(n);
    }

    private int calculateXPNeeded(int n, FormulaType formulaType) {
        int n2 = ExperienceConfig.getInstance().getBase(formulaType);
        double d = ExperienceConfig.getInstance().getMultiplier(formulaType);
        switch (formulaType) {
            case LINEAR: {
                return (int)Math.floor((double)n2 + (double)n * d);
            }
            case EXPONENTIAL: {
                double d2 = ExperienceConfig.getInstance().getExponent(formulaType);
                return (int)Math.floor(d * Math.pow(n, d2) + (double)n2);
            }
        }
        mcMMO.p.getLogger().severe("Invalid formula specified for calculation, defaulting to Linear");
        return this.calculateXPNeeded(n, FormulaType.LINEAR);
    }

    public void loadFormula() {
        if (!formulaFile.exists()) {
            this.previousFormula = FormulaType.UNKNOWN;
            return;
        }
        this.previousFormula = FormulaType.getFormulaType(YamlConfiguration.loadConfiguration((File)formulaFile).getString("Previous_Formula", "UNKNOWN"));
    }

    public void saveFormula() {
        mcMMO.p.debug("Saving previous XP formula type...");
        YamlConfiguration yamlConfiguration = new YamlConfiguration();
        yamlConfiguration.set("Previous_Formula", (Object)this.previousFormula.toString());
        try {
            yamlConfiguration.save(formulaFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

