/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.PlayerLevelUtils;
import java.util.List;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Player;

public class ExperienceBarWrapper {
    private final PrimarySkillType primarySkillType;
    private BossBar bossBar;
    protected final McMMOPlayer mcMMOPlayer;
    private int lastLevelUpdated;
    protected String niceSkillName;
    protected String title;

    public ExperienceBarWrapper(PrimarySkillType primarySkillType, McMMOPlayer mcMMOPlayer) {
        this.mcMMOPlayer = mcMMOPlayer;
        this.primarySkillType = primarySkillType;
        this.title = "";
        this.lastLevelUpdated = 0;
        this.niceSkillName = StringUtils.getCapitalized(primarySkillType.toString());
        this.initBar();
    }

    private void initBar() {
        this.title = this.getTitleTemplate();
        this.createBossBar();
    }

    public void updateTitle() {
        this.title = this.getTitleTemplate();
        this.bossBar.setTitle(this.title);
    }

    private String getTitleTemplate() {
        if (ExperienceConfig.getInstance().isEarlyGameBoostEnabled() && PlayerLevelUtils.qualifiesForEarlyGameBoost(this.mcMMOPlayer, this.primarySkillType)) {
            return LocaleLoader.getString("XPBar.Template.EarlyGameBoost");
        }
        if (ExperienceConfig.getInstance().getAddExtraDetails()) {
            return LocaleLoader.getString("XPBar.Complex.Template", LocaleLoader.getString("XPBar." + this.niceSkillName, this.getLevel()), this.getCurrentXP(), this.getMaxXP(), this.getPowerLevel(), this.getPercentageOfLevel());
        }
        return LocaleLoader.getString("XPBar." + this.niceSkillName, this.getLevel(), this.getCurrentXP(), this.getMaxXP(), this.getPowerLevel(), this.getPercentageOfLevel());
    }

    private int getLevel() {
        return this.mcMMOPlayer.getSkillLevel(this.primarySkillType);
    }

    private int getCurrentXP() {
        return this.mcMMOPlayer.getSkillXpLevel(this.primarySkillType);
    }

    private int getMaxXP() {
        return this.mcMMOPlayer.getXpToLevel(this.primarySkillType);
    }

    private int getPowerLevel() {
        return this.mcMMOPlayer.getPowerLevel();
    }

    private int getPercentageOfLevel() {
        return (int)(this.mcMMOPlayer.getProgressInCurrentSkillLevel(this.primarySkillType) * 100.0);
    }

    public String getTitle() {
        return this.bossBar.getTitle();
    }

    public void setTitle(String string) {
        this.bossBar.setTitle(string);
    }

    public BarColor getColor() {
        return this.bossBar.getColor();
    }

    public void setColor(BarColor barColor) {
        this.bossBar.setColor(barColor);
    }

    public BarStyle getStyle() {
        return this.bossBar.getStyle();
    }

    public void setStyle(BarStyle barStyle) {
        this.bossBar.setStyle(barStyle);
    }

    public void setProgress(double d) {
        if (d < 0.0) {
            this.bossBar.setProgress(0.0);
        } else if (d > 1.0) {
            this.bossBar.setProgress(1.0);
        } else {
            this.bossBar.setProgress(d);
        }
        if (ExperienceConfig.getInstance().isEarlyGameBoostEnabled() && PlayerLevelUtils.qualifiesForEarlyGameBoost(this.mcMMOPlayer, this.primarySkillType)) {
            this.setColor(BarColor.YELLOW);
        } else {
            this.setColor(ExperienceConfig.getInstance().getExperienceBarColor(this.primarySkillType));
        }
        if (this.getLevel() != this.lastLevelUpdated || ExperienceConfig.getInstance().getDoExperienceBarsAlwaysUpdateTitle()) {
            this.updateTitle();
            this.lastLevelUpdated = this.getLevel();
        }
    }

    public double getProgress() {
        return this.bossBar.getProgress();
    }

    public List<Player> getPlayers() {
        return this.bossBar.getPlayers();
    }

    public boolean isVisible() {
        return this.bossBar.isVisible();
    }

    public void hideExperienceBar() {
        this.bossBar.setVisible(false);
    }

    public void showExperienceBar() {
        this.bossBar.setVisible(true);
    }

    private void createBossBar() {
        this.bossBar = this.mcMMOPlayer.getPlayer().getServer().createBossBar(this.title, ExperienceConfig.getInstance().getExperienceBarColor(this.primarySkillType), ExperienceConfig.getInstance().getExperienceBarStyle(this.primarySkillType), new BarFlag[0]);
        this.bossBar.addPlayer(this.mcMMOPlayer.getPlayer());
    }
}

