/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.experience;

import com.gmail.nossr50.config.experience.ExperienceConfig;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.runnables.skills.ExperienceBarHideTask;
import com.gmail.nossr50.util.experience.ExperienceBarWrapper;
import java.util.HashMap;
import org.bukkit.plugin.Plugin;

public class ExperienceBarManager {
    private McMMOPlayer mcMMOPlayer;
    HashMap<PrimarySkillType, ExperienceBarWrapper> experienceBars = new HashMap();
    HashMap<PrimarySkillType, ExperienceBarHideTask> experienceBarHideTaskHashMap = new HashMap();

    public ExperienceBarManager(McMMOPlayer mcMMOPlayer) {
        this.mcMMOPlayer = mcMMOPlayer;
    }

    public void updateExperienceBar(PrimarySkillType primarySkillType, Plugin plugin) {
        if (!ExperienceConfig.getInstance().isExperienceBarsEnabled() || !ExperienceConfig.getInstance().isExperienceBarEnabled(primarySkillType)) {
            return;
        }
        if (this.experienceBars.get((Object)primarySkillType) == null) {
            this.experienceBars.put(primarySkillType, new ExperienceBarWrapper(primarySkillType, this.mcMMOPlayer));
        }
        ExperienceBarWrapper experienceBarWrapper = this.experienceBars.get((Object)primarySkillType);
        experienceBarWrapper.setProgress(this.mcMMOPlayer.getProgressInCurrentSkillLevel(primarySkillType));
        experienceBarWrapper.showExperienceBar();
        if (this.experienceBarHideTaskHashMap.get((Object)primarySkillType) != null) {
            this.experienceBarHideTaskHashMap.get((Object)primarySkillType).cancel();
            this.scheduleHideTask(primarySkillType, plugin);
        } else {
            this.scheduleHideTask(primarySkillType, plugin);
        }
    }

    private void scheduleHideTask(PrimarySkillType primarySkillType, Plugin plugin) {
        ExperienceBarHideTask experienceBarHideTask = new ExperienceBarHideTask(this, this.mcMMOPlayer, primarySkillType);
        experienceBarHideTask.runTaskLater(plugin, 40L);
        this.experienceBarHideTaskHashMap.put(primarySkillType, experienceBarHideTask);
    }

    public void hideExperienceBar(PrimarySkillType primarySkillType) {
        this.experienceBars.get((Object)primarySkillType).hideExperienceBar();
    }

    public void clearTask(PrimarySkillType primarySkillType) {
        this.experienceBarHideTaskHashMap.remove((Object)primarySkillType);
    }
}

