/*
 * Decompiled with CFR 0.152.
 */
package com.gmail.nossr50.util.commands;

import com.gmail.nossr50.config.Config;
import com.gmail.nossr50.datatypes.player.McMMOPlayer;
import com.gmail.nossr50.datatypes.player.PlayerProfile;
import com.gmail.nossr50.datatypes.skills.PrimarySkillType;
import com.gmail.nossr50.locale.LocaleLoader;
import com.gmail.nossr50.mcMMO;
import com.gmail.nossr50.util.Misc;
import com.gmail.nossr50.util.StringUtils;
import com.gmail.nossr50.util.player.UserManager;
import com.gmail.nossr50.util.skills.SkillUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public final class CommandUtils {
    public static final List<String> TRUE_FALSE_OPTIONS = ImmutableList.of((Object)"on", (Object)"off", (Object)"true", (Object)"false", (Object)"enabled", (Object)"disabled");
    public static final List<String> RESET_OPTIONS = ImmutableList.of((Object)"clear", (Object)"reset");

    private CommandUtils() {
    }

    public static boolean isChildSkill(CommandSender commandSender, PrimarySkillType primarySkillType) {
        if (primarySkillType == null || !primarySkillType.isChildSkill()) {
            return false;
        }
        commandSender.sendMessage("Child skills are not supported by this command.");
        return true;
    }

    public static boolean tooFar(CommandSender commandSender, Player player, boolean bl) {
        if (!player.isOnline() && !bl) {
            commandSender.sendMessage(LocaleLoader.getString("Inspect.Offline"));
            return true;
        }
        if (commandSender instanceof Player && !Misc.isNear(((Player)commandSender).getLocation(), player.getLocation(), Config.getInstance().getInspectDistance()) && !bl) {
            commandSender.sendMessage(LocaleLoader.getString("Inspect.TooFar"));
            return true;
        }
        return false;
    }

    public static boolean hidden(CommandSender commandSender, Player player, boolean bl) {
        return commandSender instanceof Player && !((Player)commandSender).canSee(player) && !bl;
    }

    public static boolean noConsoleUsage(CommandSender commandSender) {
        if (commandSender instanceof Player) {
            return false;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.NoConsole"));
        return true;
    }

    public static boolean isOffline(CommandSender commandSender, OfflinePlayer offlinePlayer) {
        if (offlinePlayer.isOnline()) {
            return false;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean checkPlayerExistence(CommandSender commandSender, String string, McMMOPlayer mcMMOPlayer) {
        if (mcMMOPlayer != null) {
            if (CommandUtils.hidden(commandSender, mcMMOPlayer.getPlayer(), false)) {
                commandSender.sendMessage(LocaleLoader.getString("Commands.Offline"));
                return false;
            }
            return true;
        }
        PlayerProfile playerProfile = new PlayerProfile(string, false);
        if (CommandUtils.unloadedProfile(commandSender, playerProfile)) {
            return false;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.DoesNotExist"));
        return false;
    }

    public static boolean unloadedProfile(CommandSender commandSender, PlayerProfile playerProfile) {
        if (playerProfile.isLoaded()) {
            return false;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Offline"));
        return true;
    }

    public static boolean hasPlayerDataKey(CommandSender commandSender) {
        if (commandSender == null || !(commandSender instanceof Player)) {
            return false;
        }
        boolean bl = ((Player)commandSender).hasMetadata("mcMMO: Player Data");
        if (!bl) {
            commandSender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        }
        return bl;
    }

    public static boolean isLoaded(CommandSender commandSender, PlayerProfile playerProfile) {
        if (playerProfile.isLoaded()) {
            return true;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.NotLoaded"));
        return false;
    }

    public static boolean isInvalidInteger(CommandSender commandSender, String string) {
        if (StringUtils.isInt(string)) {
            return false;
        }
        commandSender.sendMessage("That is not a valid integer.");
        return true;
    }

    public static boolean isInvalidDouble(CommandSender commandSender, String string) {
        if (StringUtils.isDouble(string)) {
            return false;
        }
        commandSender.sendMessage("That is not a valid percentage.");
        return true;
    }

    public static boolean isInvalidSkill(CommandSender commandSender, String string) {
        if (SkillUtils.isSkill(string)) {
            return false;
        }
        commandSender.sendMessage(LocaleLoader.getString("Commands.Skill.Invalid"));
        return true;
    }

    public static boolean shouldEnableToggle(String string) {
        return string.equalsIgnoreCase("on") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("enabled");
    }

    public static boolean shouldDisableToggle(String string) {
        return string.equalsIgnoreCase("off") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("disabled");
    }

    public static void printGatheringSkills(Player player, CommandSender commandSender) {
        CommandUtils.printGroupedSkillData(player, commandSender, LocaleLoader.getString("Stats.Header.Gathering"), PrimarySkillType.GATHERING_SKILLS);
    }

    public static void printGatheringSkills(Player player) {
        CommandUtils.printGatheringSkills(player, (CommandSender)player);
    }

    public static void printCombatSkills(Player player, CommandSender commandSender) {
        CommandUtils.printGroupedSkillData(player, commandSender, LocaleLoader.getString("Stats.Header.Combat"), PrimarySkillType.COMBAT_SKILLS);
    }

    public static void printCombatSkills(Player player) {
        CommandUtils.printCombatSkills(player, (CommandSender)player);
    }

    public static void printMiscSkills(Player player, CommandSender commandSender) {
        CommandUtils.printGroupedSkillData(player, commandSender, LocaleLoader.getString("Stats.Header.Misc"), PrimarySkillType.MISC_SKILLS);
    }

    public static void printMiscSkills(Player player) {
        CommandUtils.printMiscSkills(player, (CommandSender)player);
    }

    public static String displaySkill(PlayerProfile playerProfile, PrimarySkillType primarySkillType) {
        if (primarySkillType.isChildSkill()) {
            return LocaleLoader.getString("Skills.ChildStats", LocaleLoader.getString(StringUtils.getCapitalized(primarySkillType.toString()) + ".Listener") + " ", playerProfile.getSkillLevel(primarySkillType));
        }
        return LocaleLoader.getString("Skills.Stats", LocaleLoader.getString(StringUtils.getCapitalized(primarySkillType.toString()) + ".Listener") + " ", playerProfile.getSkillLevel(primarySkillType), playerProfile.getSkillXpLevel(primarySkillType), playerProfile.getXpToLevel(primarySkillType));
    }

    private static void printGroupedSkillData(Player player, CommandSender commandSender, String string, List<PrimarySkillType> list) {
        if (UserManager.getPlayer(player) == null) {
            return;
        }
        PlayerProfile playerProfile = UserManager.getPlayer(player).getProfile();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        for (PrimarySkillType primarySkillType : list) {
            if (!primarySkillType.getPermissions(player)) continue;
            arrayList.add(CommandUtils.displaySkill(playerProfile, primarySkillType));
        }
        int n = arrayList.size();
        if (n > 1) {
            commandSender.sendMessage(arrayList.toArray(new String[n]));
        }
    }

    public static List<String> getOnlinePlayerNames(CommandSender commandSender) {
        Player player = commandSender instanceof Player ? (Player)commandSender : null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Player player2 : mcMMO.p.getServer().getOnlinePlayers()) {
            if (player == null || !player.canSee(player2)) continue;
            arrayList.add(player2.getName());
        }
        return arrayList;
    }

    public static String getMatchedPlayerName(String string) {
        if (Config.getInstance().getMatchOfflinePlayers()) {
            List<String> list = CommandUtils.matchPlayer(string);
            if (list.size() == 1) {
                string = list.get(0);
            }
        } else {
            Player player = mcMMO.p.getServer().getPlayer(string);
            if (player != null) {
                string = player.getName();
            }
        }
        return string;
    }

    private static List<String> matchPlayer(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (OfflinePlayer offlinePlayer : mcMMO.p.getServer().getOfflinePlayers()) {
            String string2 = offlinePlayer.getName();
            if (string2 == null) {
                System.err.println("[McMMO] Player data file with UIID " + offlinePlayer.getUniqueId() + " is missing a player name. This may be a legacy file from before bukkit.lastKnownName. This should be okay to ignore.");
                continue;
            }
            if (string.equalsIgnoreCase(string2)) {
                arrayList.clear();
                arrayList.add(string2);
                break;
            }
            if (!string2.toLowerCase().contains(string.toLowerCase())) continue;
            arrayList.add(string2);
        }
        return arrayList;
    }
}

